/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.quests;

import com.cryptomorin.xseries.XMaterial;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.dialogs.Message;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageIndex;
import fr.skytasul.quests.api.stages.types.Dialogable;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import fr.skytasul.quests.options.OptionStartDialog;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DialogHistoryGUI
extends PagedGUI<WrappedDialogable> {
    private static Cache<List<StageIndex>, List<Dialogable>> dialogableCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Runnable end;

    public DialogHistoryGUI(@NotNull Quester quester, Quest quest, Runnable end) {
        super(quest.getName(), DyeColor.LIGHT_BLUE, Collections.emptyList(), x -> end.run(), null);
        this.end = end;
        Validate.isTrue((boolean)quester.getDataHolder().hasQuestData(quest), (String)"Quester must have started the quest");
        if (quest.hasOption(OptionStartDialog.class)) {
            this.objects.add(new WrappedDialogable(quest.getOption(OptionStartDialog.class)));
        }
        for (Dialogable dialogable : DialogHistoryGUI.getDialogable(quester.getDataHolder().getQuestData(quest), false)) {
            this.objects.add(new WrappedDialogable(dialogable));
        }
    }

    @Override
    public ItemStack getItemStack(WrappedDialogable object) {
        return object.setMeta(ItemUtils.clearVisibleAttributes(XMaterial.WRITTEN_BOOK.parseItem()));
    }

    @Override
    public void click(WrappedDialogable existing, ItemStack item, ClickType clickType) {
        boolean changed = false;
        if (clickType.isLeftClick()) {
            if (existing.page > 0) {
                --existing.page;
                changed = true;
                QuestUtils.playPluginSound(QuestsPlugin.getPlugin().getAudiences().player(this.player), "ENTITY_BAT_TAKEOFF", 0.4f, 1.5f);
            }
        } else if (clickType.isRightClick() && existing.page + 1 < existing.pages.size()) {
            ++existing.page;
            changed = true;
            QuestUtils.playPluginSound(QuestsPlugin.getPlugin().getAudiences().player(this.player), "ENTITY_BAT_TAKEOFF", 0.4f, 1.7f);
        }
        if (changed) {
            existing.setMeta(item);
        }
    }

    @Override
    public CloseBehavior onClose(Player p) {
        QuestUtils.runSync(this.end);
        return StandardCloseBehavior.NOTHING;
    }

    public static List<Dialogable> getDialogable(QuesterQuestData datas, boolean useCache) {
        List<Dialogable> dialogable;
        block3: {
            block2: {
                dialogable = (List<Dialogable>)dialogableCache.getIfPresent(datas.getQuestFlow());
                if (!useCache) break block2;
                if (dialogable != null) break block3;
            }
            dialogable = datas.getQuestFlowStages().map(StageController::getStage).filter(Dialogable.class::isInstance).map(Dialogable.class::cast).filter(Dialogable::hasDialog).toList();
            dialogableCache.put(new ArrayList<StageIndex>(datas.getQuestFlow()), dialogable);
        }
        return dialogable;
    }

    class WrappedDialogable {
        static final int MAX_LINES = 9;
        final Dialogable dialogable;
        int page = 0;
        private List<Page> pages;

        WrappedDialogable(Dialogable dialogable) {
            this.dialogable = dialogable;
        }

        private void fetchPages() {
            List<Message> messages = this.dialogable.getDialog().getMessages();
            ArrayList<List<String>> lines = new ArrayList<List<String>>(messages.size());
            for (int i = 0; i < messages.size(); ++i) {
                Message msg = messages.get(i);
                String formatted = msg.formatMessage(DialogHistoryGUI.this.getViewer(), this.dialogable.getNPC(), this.dialogable.getDialog().getNPCName(this.dialogable.getNPC()), i, messages.size());
                lines.add(ChatColorUtils.wordWrap(formatted, 40, 100));
            }
            if (lines.isEmpty()) {
                this.pages = Arrays.asList(new Page());
                return;
            }
            this.pages = new ArrayList<Page>();
            Page page = new Page();
            int messagesAdded = 0;
            int messagesInPage = 0;
            for (int i = 0; i < lines.size(); ++i) {
                boolean pageFull;
                List msg = (List)lines.get(i);
                boolean last = i + 1 == lines.size();
                boolean bl = pageFull = !page.lines.isEmpty() && page.lines.size() + msg.size() > 9;
                if (QuestsConfiguration.getConfig().getDialogsConfig().getMaxMessagesPerHistoryPage() > 0) {
                    pageFull |= messagesInPage >= QuestsConfiguration.getConfig().getDialogsConfig().getMaxMessagesPerHistoryPage();
                }
                if (last || pageFull) {
                    boolean added = false;
                    if (page.lines.isEmpty() || last && !pageFull) {
                        page.lines.addAll(msg);
                        ++messagesAdded;
                        ++messagesInPage;
                        added = true;
                    }
                    page.header = "\u00a77\u00a7l" + messagesAdded + "\u00a78 / \u00a77\u00a7l" + Lang.AmountDialogLines.quickFormat("lines_amount", messages.size());
                    page.lines.addLast("  " + (this.pages.isEmpty() ? "\u00a78" : "\u00a77") + "\u25c0 " + String.valueOf(Lang.ClickLeft) + " \u00a78/ " + (last && !pageFull ? "\u00a78" : "\u00a77") + String.valueOf(Lang.ClickRight) + " \u25b6");
                    this.pages.add(page);
                    page = new Page();
                    messagesInPage = 0;
                    if (added) continue;
                }
                ++messagesAdded;
                ++messagesInPage;
                page.lines.addAll(msg);
            }
            if (!page.lines.isEmpty()) {
                page.header = "\u00a77\u00a7l" + messagesAdded + "\u00a78 / \u00a77\u00a7l" + Lang.AmountDialogLines.quickFormat("lines_amount", messages.size());
                page.lines.addLast("  " + (this.pages.isEmpty() ? "\u00a78" : "\u00a77") + "\u25c0 " + String.valueOf(Lang.ClickLeft) + " \u00a78/ " + String.valueOf(Lang.ClickRight) + " \u25b6");
                this.pages.add(page);
            }
        }

        public Page getCurrentPage() {
            if (this.pages == null) {
                this.fetchPages();
            }
            return this.pages.get(this.page);
        }

        public ItemStack setMeta(ItemStack item) {
            return ItemUtils.nameAndLore(item, "\u00a78" + DialogHistoryGUI.this.objects.indexOf(this) + " (" + this.dialogable.getNpcName() + "\u00a78) - " + this.getCurrentPage().header, this.getCurrentPage().lines);
        }
    }

    class Page {
        LinkedList<String> lines = new LinkedList();
        String header;

        Page() {
        }
    }
}

