/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.quests;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.options.description.QuestDescriptionContext;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.PlayerListCategory;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.gui.quests.DialogHistoryGUI;
import fr.skytasul.quests.options.OptionStartDialog;
import fr.skytasul.quests.options.OptionStartable;
import fr.skytasul.quests.scoreboards.Scoreboard;
import fr.skytasul.quests.utils.QuestUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerListGUI
extends PagedGUI<Quest> {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.PlayerListGUI");
    static final String UNSELECTED_PREFIX = "\u00a77\u25cb ";
    private static final String SELECTED_PREFIX = "\u00a7b\u00a7l\u25cf ";
    @NotNull
    private final Player player;
    private final boolean showHidden;
    @NotNull
    private final Collection<? extends Quester> questers;
    @Nullable
    private Map<Quest, Quester> quests;
    @Nullable
    private PlayerListCategory cat = null;

    public PlayerListGUI(@NotNull QuesterManager questerManager, @NotNull Player player, boolean showHidden) {
        super(Lang.INVENTORY_PLAYER_LIST.quickFormat("player_name", player.getName()), DyeColor.GRAY, Collections.emptyList());
        this.player = player;
        this.showHidden = showHidden;
        this.questers = questerManager.getPlayerQuesters(player);
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
        this.setObjects(Collections.emptyList());
        super.populate(player, inventory);
        for (PlayerListCategory enabledCat : QuestsConfiguration.getConfig().getQuestsMenuConfig().getEnabledTabs()) {
            this.setBarItem(enabledCat.getSlot(), ItemUtils.name(enabledCat.getIcon(), UNSELECTED_PREFIX + enabledCat.getName()));
        }
        if (PlayerListCategory.IN_PROGRESS.isEnabled()) {
            this.setCategory(PlayerListCategory.IN_PROGRESS);
            if (this.objects.isEmpty() && QuestsConfiguration.getConfig().getQuestsMenuConfig().isNotStartedTabOpenedWhenEmpty() && PlayerListCategory.NOT_STARTED.isEnabled()) {
                this.setCategory(PlayerListCategory.NOT_STARTED);
            }
        } else if (PlayerListCategory.NOT_STARTED.isEnabled()) {
            this.setCategory(PlayerListCategory.NOT_STARTED);
        } else {
            this.setCategory(PlayerListCategory.FINISHED);
        }
    }

    private void setCategory(PlayerListCategory category) {
        if (this.cat == category) {
            return;
        }
        if (this.cat != null) {
            this.setCategorySelected(false);
        }
        this.cat = category;
        this.setCategorySelected(true);
        this.setSeparatorColor(this.cat.getColor());
        this.quests = new HashMap<Quest, Quester>();
        for (Quester quester : this.questers) {
            List<? extends Quest> questerQuests = switch (this.cat) {
                case PlayerListCategory.FINISHED -> QuestsAPI.getAPI().getQuestsManager().getQuestsFinished(quester, !this.showHidden);
                case PlayerListCategory.IN_PROGRESS -> QuestsAPI.getAPI().getQuestsManager().getQuestsStarted(quester, true, false);
                case PlayerListCategory.NOT_STARTED -> QuestsAPI.getAPI().getQuestsManager().getQuestsNotStarted(quester, !this.showHidden, true).stream().filter(quest -> !quest.isHiddenWhenRequirementsNotMet() || quest.canStart(this.player, false)).collect(Collectors.toList());
                default -> throw new UnsupportedOperationException();
            };
            for (Quest quest2 : questerQuests) {
                this.quests.put(quest2, quester);
            }
        }
        this.setObjects(this.quests.keySet().stream().sorted().toList());
    }

    @Override
    @NotNull
    public ItemStack getItemStack(@NotNull Quest qu) {
        ItemStack item;
        Quester quester = this.quests.get(qu);
        boolean glittering = false;
        try {
            List<String> lore = new QuestDescriptionContext(QuestsConfiguration.getConfig().getQuestDescriptionConfig(), qu, this.player, quester, this.cat, DescriptionSource.MENU).formatDescription();
            switch (this.cat) {
                case FINISHED: {
                    if (!QuestsConfiguration.getConfig().getDialogsConfig().isHistoryEnabled() || !PlayerListGUI.hadDialog(qu, quester)) break;
                    if (!lore.isEmpty()) {
                        lore.add(null);
                    }
                    lore.add("\u00a78" + String.valueOf(Lang.ClickRight) + " \u00a78> " + String.valueOf(Lang.dialogsHistoryLore));
                    break;
                }
                case IN_PROGRESS: {
                    Scoreboard scoreboard;
                    ArrayList<CallSite> additionalLore = new ArrayList<CallSite>();
                    if (QuestsConfiguration.getConfig().getQuestsMenuConfig().allowPlayerCancelQuest() && qu.isCancellable()) {
                        additionalLore.add((CallSite)((Object)("\u00a78" + String.valueOf(Lang.ClickLeft) + " \u00a78> " + String.valueOf(Lang.cancelLore))));
                    }
                    if (QuestsConfiguration.getConfig().getDialogsConfig().isHistoryEnabled() && PlayerListGUI.hadDialog(qu, quester)) {
                        additionalLore.add((CallSite)((Object)("\u00a78" + String.valueOf(Lang.ClickRight) + " \u00a78> " + String.valueOf(Lang.dialogsHistoryLore))));
                    }
                    if (BeautyQuests.getInstance().getScoreboardManager() != null && qu.isScoreboardEnabled() && (scoreboard = BeautyQuests.getInstance().getScoreboardManager().getPlayerScoreboard(this.player)) != null) {
                        boolean isPinned = scoreboard.getEntry(qu, quester).map(entry -> entry.isPinned()).orElse(false);
                        additionalLore.add((CallSite)((Object)("\u00a78" + String.valueOf(Lang.ClickShiftLeft) + " \u00a78> " + String.valueOf(isPinned ? Lang.scoreboardUnpinLore : Lang.scoreboardPinLore))));
                        if (isPinned) {
                            glittering = true;
                        }
                    }
                    if (!additionalLore.isEmpty() && !lore.isEmpty()) {
                        lore.add(null);
                    }
                    lore.addAll(additionalLore);
                    break;
                }
                case NOT_STARTED: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            item = ItemUtils.nameAndLore(qu.getQuestItem().clone(), this.player.hasPermission("beautyquests.seeId") ? Lang.formatId.format((HasPlaceholders)qu) : Lang.formatNormal.format((HasPlaceholders)qu), lore);
            ItemUtils.setGlittering(item, glittering);
        }
        catch (Exception ex) {
            item = ItemUtils.item(XMaterial.BARRIER, "\u00a7cError - Quest #" + qu.getId(), new String[0]);
            LOGGER.severe("An error ocurred when creating item of quest {} for {}", ex, qu.getId(), quester.getDetailedName());
        }
        return item;
    }

    @Override
    protected void barClick(GuiClickEvent event, int barSlot) {
        Optional<PlayerListCategory> clickedCat = Arrays.stream(PlayerListCategory.values()).filter(cat -> cat.getSlot() == barSlot).findAny();
        if (clickedCat.isPresent()) {
            if (clickedCat.get().isEnabled()) {
                this.setCategory(clickedCat.get());
            }
        } else {
            super.barClick(event, barSlot);
        }
    }

    @Override
    public void click(@NotNull Quest qu, @NotNull ItemStack item, @NotNull ClickType clickType) {
        Quester quester = this.quests.get(qu);
        if (this.cat == PlayerListCategory.NOT_STARTED) {
            if (!((Boolean)qu.getOptionValueOrDef(OptionStartable.class)).booleanValue()) {
                return;
            }
            if (!quester.isActive()) {
                return;
            }
            if (qu.canStart(this.player, true)) {
                this.close();
                qu.attemptStart(this.player).whenComplete((BiConsumer)LOGGER.logError(result -> {
                    if (result.booleanValue() && QuestsConfiguration.getConfig().getQuestsMenuConfig().keepMenuOpen()) {
                        this.reopen(this.getViewer(), true);
                    }
                }, "An error occurred while giving a quest to {}", null, this.player.getName()));
            }
        } else {
            switch (clickType) {
                case LEFT: {
                    if (!QuestsConfiguration.getConfig().getQuestsMenuConfig().allowPlayerCancelQuest() || this.cat != PlayerListCategory.IN_PROGRESS || !qu.isCancellable()) break;
                    QuestsPlugin.getPlugin().getGuiManager().getFactory().createConfirmation(() -> {
                        qu.cancelQuester(quester);
                        if (QuestsConfiguration.getConfig().getQuestsMenuConfig().keepMenuOpen()) {
                            this.reopen(this.getViewer(), true);
                        }
                    }, this::reopen, Lang.INDICATION_CANCEL.format((HasPlaceholders)qu), new String[0]).open(this.player);
                    break;
                }
                case RIGHT: {
                    if (!QuestsConfiguration.getConfig().getDialogsConfig().isHistoryEnabled() || !PlayerListGUI.hadDialog(qu, quester)) break;
                    QuestUtils.playPluginSound(QuestsPlugin.getPlugin().getAudiences().player(this.getViewer()), "ITEM_BOOK_PAGE_TURN", 0.5f, 1.4f);
                    new DialogHistoryGUI(quester, qu, this::reopen).open(this.getViewer());
                    break;
                }
                case SHIFT_LEFT: {
                    Scoreboard sb;
                    if (this.cat != PlayerListCategory.IN_PROGRESS || !qu.isScoreboardEnabled() || BeautyQuests.getInstance().getScoreboardManager() == null || (sb = BeautyQuests.getInstance().getScoreboardManager().getPlayerScoreboard(this.player)) == null) break;
                    sb.getEntry(qu, quester).ifPresent(entry -> {
                        entry.setPinned(!entry.isPinned());
                        this.setItems();
                    });
                    break;
                }
            }
        }
    }

    private static boolean hadDialog(Quest quest, Quester quester) {
        Optional<QuesterQuestData> data = quester.getDataHolder().getQuestDataIfPresent(quest);
        if (data.isEmpty()) {
            return false;
        }
        if (!data.get().hasStarted() && !data.get().hasFinishedOnce()) {
            return false;
        }
        if (quest.hasOption(OptionStartDialog.class)) {
            return true;
        }
        return !DialogHistoryGUI.getDialogable(data.get(), true).isEmpty();
    }

    private void setCategorySelected(boolean selected) {
        String name;
        ItemStack is = this.getInventory().getItem(this.cat.getSlot() * 9 + 8);
        if (selected) {
            ItemUtils.setGlittering(is, true);
            name = SELECTED_PREFIX + this.cat.getName();
        } else {
            ItemUtils.setGlittering(is, false);
            name = UNSELECTED_PREFIX + this.cat.getName();
        }
        ItemUtils.name(is, name);
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return StandardCloseBehavior.REMOVE;
    }
}

