/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.gui.quests;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.Quest;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class QuestsListGUI
extends PagedGUI<Quest> {
    public Consumer<Quest> run;

    public QuestsListGUI(Consumer<Quest> run, Quester acc, boolean started, boolean notStarted, boolean finished) {
        super(Lang.INVENTORY_QUESTS_LIST.toString(), DyeColor.CYAN, new ArrayList(), null, Quest::getName);
        if (acc != null) {
            if (started) {
                this.objects.addAll(QuestsAPI.getAPI().getQuestsManager().getQuestsStarted(acc));
            }
            if (notStarted) {
                this.objects.addAll(QuestsAPI.getAPI().getQuestsManager().getQuestsNotStarted(acc, false, true));
            }
            if (finished) {
                this.objects.addAll(QuestsAPI.getAPI().getQuestsManager().getQuestsFinished(acc, false));
            }
        } else {
            this.objects.addAll(QuestsAPI.getAPI().getQuestsManager().getQuests());
        }
        this.run = run;
    }

    @Override
    public ItemStack getItemStack(Quest qu) {
        return ItemUtils.nameAndLore(qu.getQuestItem().clone(), "\u00a76\u00a7l\u00a7o" + qu.getName() + "    \u00a7r\u00a7e#" + qu.getId(), qu.getDescription());
    }

    @Override
    public void click(Quest existing, ItemStack item, ClickType clickType) {
        this.close(this.player);
        this.run.accept(existing);
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return StandardCloseBehavior.REMOVE;
    }
}

