/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations;

import fr.skytasul.quests.api.AbstractHolograms;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.filoghost.holographicdisplays.api.HolographicDisplaysAPI;
import me.filoghost.holographicdisplays.api.hologram.Hologram;
import me.filoghost.holographicdisplays.api.hologram.VisibilitySettings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BQHolographicDisplays3
extends AbstractHolograms<Hologram> {
    private final HolographicDisplaysAPI api = HolographicDisplaysAPI.get((Plugin)Bukkit.getPluginManager().getPlugin("HolographicDisplays"));
    private Field visibilitiesField;

    @Override
    public boolean supportPerPlayerVisibility() {
        return true;
    }

    @Override
    public boolean supportItems() {
        return true;
    }

    @Override
    public HD3Hologram createHologram(Location lc, boolean visible) {
        Hologram holo = this.api.createHologram(lc);
        holo.getVisibilitySettings().setGlobalVisibility(this.booleanToVisibility(visible));
        return new HD3Hologram(holo);
    }

    private VisibilitySettings.Visibility booleanToVisibility(boolean visible) {
        return visible ? VisibilitySettings.Visibility.VISIBLE : VisibilitySettings.Visibility.HIDDEN;
    }

    public class HD3Hologram
    extends AbstractHolograms.BQHologram {
        protected HD3Hologram(Hologram hologram) {
            super(hologram);
        }

        @Override
        public void setPlayersVisible(List<Player> players) {
            try {
                ConcurrentHashMap<UUID, VisibilitySettings.Visibility> map;
                List all = players.stream().map(OfflinePlayer::getUniqueId).collect(Collectors.toList());
                VisibilitySettings visibility = ((Hologram)this.hologram).getVisibilitySettings();
                if (BQHolographicDisplays3.this.visibilitiesField == null) {
                    BQHolographicDisplays3.this.visibilitiesField = visibility.getClass().getDeclaredField("individualVisibilities");
                    BQHolographicDisplays3.this.visibilitiesField.setAccessible(true);
                }
                if ((map = (ConcurrentHashMap<UUID, VisibilitySettings.Visibility>)BQHolographicDisplays3.this.visibilitiesField.get(visibility)) == null) {
                    map = new ConcurrentHashMap<UUID, VisibilitySettings.Visibility>();
                    BQHolographicDisplays3.this.visibilitiesField.set(visibility, map);
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (all.remove(entry.getKey())) {
                        if (entry.getValue() != VisibilitySettings.Visibility.HIDDEN) continue;
                        entry.setValue(VisibilitySettings.Visibility.VISIBLE);
                        continue;
                    }
                    if (entry.getValue() != VisibilitySettings.Visibility.VISIBLE) continue;
                    entry.setValue(VisibilitySettings.Visibility.HIDDEN);
                }
                for (UUID uUID : all) {
                    map.put(uUID, VisibilitySettings.Visibility.VISIBLE);
                }
            }
            catch (ReflectiveOperationException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void setPlayerVisibility(Player p, boolean visible) {
            ((Hologram)this.hologram).getVisibilitySettings().setIndividualVisibility(p, BQHolographicDisplays3.this.booleanToVisibility(visible));
        }

        @Override
        public void appendItem(ItemStack item) {
            ((Hologram)this.hologram).getLines().appendItem(item);
        }

        @Override
        public void appendTextLine(String text) {
            ((Hologram)this.hologram).getLines().appendText(text);
        }

        @Override
        public void teleport(Location lc) {
            ((Hologram)this.hologram).setPosition(lc);
        }

        @Override
        public void delete() {
            ((Hologram)this.hologram).delete();
        }
    }
}

