/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.integrations.IntegrationsLoader;
import org.bukkit.configuration.file.FileConfiguration;

public class IntegrationsConfiguration {
    private final FileConfiguration config;
    private String dSetName = "Quests";
    private String dIcon = "bookshelf";
    private int dMinZoom = 0;
    private boolean mythicMobsPetKillToOwner = true;

    public IntegrationsConfiguration(FileConfiguration config) {
        this.config = config;
    }

    public void load() {
        if (this.config.getBoolean("skillAPIoverride", false)) {
            this.config.set("skillAPIoverride", null);
            QuestsPlugin.getPlugin().getLogger().warning("The config option \"skillAPIoverride\" is no longer supported. You must change your vanilla XP rewards to specialized SkillAPI XP rewards.");
        }
        this.dSetName = this.config.getString("dynmap.markerSetName");
        this.dIcon = this.config.getString("dynmap.markerIcon");
        this.dMinZoom = this.config.getInt("dynmap.minZoom");
        this.mythicMobsPetKillToOwner = this.config.getBoolean("mythicmobs.count kill for pet owner");
    }

    public String dynmapSetName() {
        return this.dSetName;
    }

    public String dynmapMarkerIcon() {
        return this.dIcon;
    }

    public int dynmapMinimumZoom() {
        return this.dMinZoom;
    }

    public boolean mythicMobsPetKillToOwner() {
        return this.mythicMobsPetKillToOwner;
    }

    public static IntegrationsConfiguration getConfiguration() {
        return IntegrationsLoader.getInstance().getConfig();
    }
}

