/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.AbstractHolograms;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementCreator;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardCreator;
import fr.skytasul.quests.api.utils.IntegrationManager;
import fr.skytasul.quests.integrations.BQCMI;
import fr.skytasul.quests.integrations.BQDecentHolograms;
import fr.skytasul.quests.integrations.BQHolographicDisplays2;
import fr.skytasul.quests.integrations.BQHolographicDisplays3;
import fr.skytasul.quests.integrations.BQItemsAdder;
import fr.skytasul.quests.integrations.BQMMOItems;
import fr.skytasul.quests.integrations.BQTokenEnchant;
import fr.skytasul.quests.integrations.BQUltimateTimber;
import fr.skytasul.quests.integrations.IntegrationsConfiguration;
import fr.skytasul.quests.integrations.fabled.FabledClassRequirement;
import fr.skytasul.quests.integrations.fabled.FabledLevelRequirement;
import fr.skytasul.quests.integrations.fabled.FabledXpReward;
import fr.skytasul.quests.integrations.factions.FactionRequirement;
import fr.skytasul.quests.integrations.jobs.JobLevelRequirement;
import fr.skytasul.quests.integrations.maps.BQBlueMap;
import fr.skytasul.quests.integrations.maps.BQDynmap;
import fr.skytasul.quests.integrations.mcmmo.McCombatLevelRequirement;
import fr.skytasul.quests.integrations.mcmmo.McMMOSkillRequirement;
import fr.skytasul.quests.integrations.mobs.BQAdvancedSpawners;
import fr.skytasul.quests.integrations.mobs.BQBoss;
import fr.skytasul.quests.integrations.mobs.BQLevelledMobs;
import fr.skytasul.quests.integrations.mobs.BQStackMob;
import fr.skytasul.quests.integrations.mobs.BQWildStacker;
import fr.skytasul.quests.integrations.mobs.CitizensFactory;
import fr.skytasul.quests.integrations.mobs.MythicMobs;
import fr.skytasul.quests.integrations.mobs.MythicMobs5;
import fr.skytasul.quests.integrations.npcs.BQCitizens;
import fr.skytasul.quests.integrations.npcs.BQFancyNPCs;
import fr.skytasul.quests.integrations.npcs.BQMythicMobs5Npcs;
import fr.skytasul.quests.integrations.npcs.BQSentinel;
import fr.skytasul.quests.integrations.npcs.BQServerNPCs;
import fr.skytasul.quests.integrations.npcs.BQZNPCsPlus;
import fr.skytasul.quests.integrations.placeholders.PapiMessageProcessor;
import fr.skytasul.quests.integrations.placeholders.PlaceholderRequirement;
import fr.skytasul.quests.integrations.placeholders.QuestsPlaceholders;
import fr.skytasul.quests.integrations.tooltips.TooltipsMessageSender;
import fr.skytasul.quests.integrations.vault.economy.MoneyRequirement;
import fr.skytasul.quests.integrations.vault.economy.MoneyReward;
import fr.skytasul.quests.integrations.vault.permission.PermissionReward;
import fr.skytasul.quests.integrations.worldguard.BQWorldGuard;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class IntegrationsLoader {
    private static IntegrationsLoader instance;
    private IntegrationsConfiguration config;

    public static IntegrationsLoader getInstance() {
        return instance;
    }

    public IntegrationsLoader() {
        instance = this;
        this.config = new IntegrationsConfiguration(QuestsPlugin.getPlugin().getConfig());
        this.config.load();
        IntegrationManager manager = QuestsPlugin.getPlugin().getIntegrationManager();
        manager.addDependency(new IntegrationManager.BQDependency("ServersNPC", this::registerZNPCs, null, this::isZNPCsVersionValid));
        manager.addDependency(new IntegrationManager.BQDependency("ZNPCsPlus", this::registerZnpcsPlus));
        manager.addDependency(new IntegrationManager.BQDependency("FancyNpcs", () -> QuestsAPI.getAPI().addNpcFactory("fancynpcs", new BQFancyNPCs())));
        manager.addDependency(new IntegrationManager.BQDependency("Citizens", () -> {
            QuestsAPI.getAPI().addNpcFactory("citizens", new BQCitizens());
            QuestsAPI.getAPI().registerMobFactory(new CitizensFactory());
        }));
        manager.addDependency(new IntegrationManager.BQDependency("MythicMobs", this::registerMythicMobs));
        manager.addDependency(new IntegrationManager.BQDependency("Boss", () -> QuestsAPI.getAPI().registerMobFactory(new BQBoss()), null, this::isBossVersionValid));
        manager.addDependency(new IntegrationManager.BQDependency("AdvancedSpawners", () -> QuestsAPI.getAPI().registerMobFactory(new BQAdvancedSpawners())));
        manager.addDependency(new IntegrationManager.BQDependency("LevelledMobs", () -> QuestsAPI.getAPI().registerMobFactory(new BQLevelledMobs())));
        manager.addDependency(new IntegrationManager.BQDependency("WildStacker", BQWildStacker::initialize));
        manager.addDependency(new IntegrationManager.BQDependency("StackMob", BQStackMob::initialize));
        manager.addDependency(new IntegrationManager.BQDependency("Fabled", this::registerFabled, null, this::isFabledValid).addPluginName("ProSkillAPI").addPluginName("SkillAPI"));
        manager.addDependency(new IntegrationManager.BQDependency("Jobs", this::registerJobs));
        manager.addDependency(new IntegrationManager.BQDependency("Factions", this::registerFactions));
        manager.addDependency(new IntegrationManager.BQDependency("mcMMO", this::registerMcMmo));
        manager.addDependency(new IntegrationManager.BQDependency("McCombatLevel", this::registerMcCombatLevel));
        manager.addDependency(new IntegrationManager.BQDependency("Vault", this::registerVault));
        if (this.config.dynmapSetName() != null && !this.config.dynmapSetName().isEmpty()) {
            manager.addDependency(new IntegrationManager.BQDependency("dynmap", () -> QuestsAPI.getAPI().registerQuestsHandler(new BQDynmap())));
            manager.addDependency(new IntegrationManager.BQDependency("BlueMap", () -> QuestsAPI.getAPI().registerQuestsHandler(new BQBlueMap())));
        }
        manager.addDependency(new IntegrationManager.BQDependency("CMI", () -> {
            if (BQCMI.areHologramsEnabled()) {
                QuestsAPI.getAPI().setHologramsManager(new BQCMI());
            }
        }));
        manager.addDependency(new IntegrationManager.BQDependency("HolographicDisplays", this::registerHolographicDisplays));
        manager.addDependency(new IntegrationManager.BQDependency("DecentHolograms", () -> QuestsAPI.getAPI().setHologramsManager(new BQDecentHolograms())));
        manager.addDependency(new IntegrationManager.BQDependency("PlaceholderAPI", this::registerPapi));
        manager.addDependency(new IntegrationManager.BQDependency("WorldGuard", BQWorldGuard::initialize, BQWorldGuard::unload));
        manager.addDependency(new IntegrationManager.BQDependency("Sentinel", BQSentinel::initialize));
        manager.addDependency(new IntegrationManager.BQDependency("TokenEnchant", () -> Bukkit.getPluginManager().registerEvents((Listener)new BQTokenEnchant(), (Plugin)QuestsPlugin.getPlugin())));
        manager.addDependency(new IntegrationManager.BQDependency("UltimateTimber", () -> Bukkit.getPluginManager().registerEvents((Listener)new BQUltimateTimber(), (Plugin)QuestsPlugin.getPlugin()), null, this::isUltimateTimberValid));
        manager.addDependency(new IntegrationManager.BQDependency("ItemsAdder", BQItemsAdder::initialize, BQItemsAdder::unload));
        manager.addDependency(new IntegrationManager.BQDependency("MMOItems", BQMMOItems::initialize, BQMMOItems::unload));
        manager.addDependency(new IntegrationManager.BQDependency("Tooltips", this::registerTooltips));
    }

    private void registerPapi() {
        QuestsPlaceholders.registerPlaceholders(QuestsPlugin.getPlugin().getConfig().getConfigurationSection("startedQuestsPlaceholder"));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("placeholderRequired", (Class<? extends AbstractRequirement>)PlaceholderRequirement.class, ItemUtils.item(XMaterial.NAME_TAG, Lang.RPlaceholder.toString(), new String[0]), PlaceholderRequirement::new));
        QuestsAPI.getAPI().registerMessageProcessor("placeholderapi_replace", 5, new PapiMessageProcessor());
    }

    private void registerVault() {
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("moneyReward", (Class<? extends AbstractReward>)MoneyReward.class, ItemUtils.item(XMaterial.EMERALD, Lang.rewardMoney.toString(), new String[0]), MoneyReward::new));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("permReward", (Class<? extends AbstractReward>)PermissionReward.class, ItemUtils.item(XMaterial.REDSTONE_TORCH, Lang.rewardPerm.toString(), new String[0]), PermissionReward::new));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("moneyRequired", (Class<? extends AbstractRequirement>)MoneyRequirement.class, ItemUtils.item(XMaterial.EMERALD, Lang.RMoney.toString(), new String[0]), MoneyRequirement::new));
    }

    private void registerHolographicDisplays() {
        AbstractHolograms holograms;
        try {
            Class.forName("com.gmail.filoghost.holographicdisplays.HolographicDisplays");
            holograms = new BQHolographicDisplays2();
        }
        catch (ClassNotFoundException ex) {
            try {
                Class.forName("me.filoghost.holographicdisplays.plugin.HolographicDisplays");
                holograms = new BQHolographicDisplays3();
            }
            catch (ClassNotFoundException ex1) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Your version of HolographicDisplays is unsupported. Please make sure you are running the LATEST dev build of HolographicDisplays.");
                return;
            }
        }
        QuestsAPI.getAPI().setHologramsManager(holograms);
    }

    private void registerMcCombatLevel() {
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("mcmmoCombatLevelRequirement", (Class<? extends AbstractRequirement>)McCombatLevelRequirement.class, ItemUtils.item(XMaterial.IRON_SWORD, Lang.RCombatLvl.toString(), new String[0]), McCombatLevelRequirement::new));
    }

    private void registerMcMmo() {
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("mcmmoSklillLevelRequired", (Class<? extends AbstractRequirement>)McMMOSkillRequirement.class, ItemUtils.item(XMaterial.IRON_CHESTPLATE, Lang.RSkillLvl.toString(), new String[0]), McMMOSkillRequirement::new));
    }

    private void registerFactions() {
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("factionRequired", (Class<? extends AbstractRequirement>)FactionRequirement.class, ItemUtils.item(XMaterial.WITHER_SKELETON_SKULL, Lang.RFaction.toString(), new String[0]), FactionRequirement::new));
    }

    private void registerJobs() {
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("jobLevelRequired", (Class<? extends AbstractRequirement>)JobLevelRequirement.class, ItemUtils.item(XMaterial.LEATHER_CHESTPLATE, Lang.RJobLvl.toString(), new String[0]), JobLevelRequirement::new));
    }

    private void registerFabled() {
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("classRequired", (Class<? extends AbstractRequirement>)FabledClassRequirement.class, ItemUtils.item(XMaterial.GHAST_TEAR, Lang.RClass.toString(), new String[0]), FabledClassRequirement::new));
        QuestsAPI.getAPI().getRequirements().register(new RequirementCreator("skillAPILevelRequired", (Class<? extends AbstractRequirement>)FabledLevelRequirement.class, ItemUtils.item(XMaterial.EXPERIENCE_BOTTLE, Lang.RSkillAPILevel.toString(), new String[0]), FabledLevelRequirement::new));
        QuestsAPI.getAPI().getRewards().register(new RewardCreator("skillAPI-exp", (Class<? extends AbstractReward>)FabledXpReward.class, ItemUtils.item(XMaterial.EXPERIENCE_BOTTLE, Lang.RWSkillApiXp.toString(), new String[0]), FabledXpReward::new));
    }

    private boolean isFabledValid(Plugin plugin) {
        if (plugin.getName().equals("SkillAPI") || plugin.getName().equals("ProSkillAPI")) {
            QuestsPlugin.getPlugin().getLogger().warning("SkillAPI and ProSKillAPI are no longer supported. You must upgrade to their newer version: Fabled (https://www.spigotmc.org/resources/91913)");
            return false;
        }
        return true;
    }

    private boolean isUltimateTimberValid(Plugin plugin) {
        try {
            Class.forName("com.craftaro.ultimatetimber.UltimateTimber");
        }
        catch (ClassNotFoundException ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Your version of UltimateTimber (" + plugin.getDescription().getVersion() + ") is not compatible with BeautyQuests. Please use 3.0.0 or higher.");
            return false;
        }
        return true;
    }

    private boolean isBossVersionValid(Plugin plugin) {
        try {
            Class.forName("org.mineacademy.boss.model.Boss");
        }
        catch (ClassNotFoundException ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Your version of Boss (" + plugin.getDescription().getVersion() + ") is not compatible with BeautyQuests.");
            return false;
        }
        return true;
    }

    private void registerMythicMobs() {
        try {
            Class.forName("io.lumine.mythic.api.MythicPlugin");
            QuestsAPI.getAPI().registerMobFactory(new MythicMobs5());
            QuestsAPI.getAPI().addNpcFactory("mythicmobs", new BQMythicMobs5Npcs());
        }
        catch (ClassNotFoundException ex) {
            QuestsAPI.getAPI().registerMobFactory(new MythicMobs());
        }
    }

    private boolean isZNPCsVersionValid(Plugin plugin) {
        if (plugin.getClass().getName().equals("io.github.gonalez.znpcs.ServersNPC")) {
            return true;
        }
        QuestsPlugin.getPlugin().getLoggerExpanded().warning("Your version of znpcs ({}) is not supported by BeautyQuests.", plugin.getDescription().getVersion());
        return false;
    }

    private void registerZNPCs() {
        QuestsAPI.getAPI().addNpcFactory("znpcs", new BQServerNPCs());
    }

    private void registerZnpcsPlus() {
        QuestsAPI.getAPI().addNpcFactory("znpcsplus", new BQZNPCsPlus());
    }

    private void registerTooltips() {
        QuestsAPI.getAPI().setMessageSender(new TooltipsMessageSender());
    }

    public IntegrationsConfiguration getConfig() {
        return this.config;
    }
}

