/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.fabled;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.DyeColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.player.PlayerClass;

public class FabledClassRequirement
extends AbstractRequirement {
    public List<FabledClass> classes;

    public FabledClassRequirement() {
        this(null, null, new ArrayList<FabledClass>());
    }

    public FabledClassRequirement(String customDescription, String customReason, List<FabledClass> classes) {
        super(customDescription, customReason);
        this.classes = classes;
    }

    public List<String> getClassesName() {
        ArrayList<String> ls = new ArrayList<String>();
        for (FabledClass cl : this.classes) {
            ls.add(cl.getName());
        }
        return ls;
    }

    public void addClass(Object classe) {
        this.classes.add((FabledClass)classe);
    }

    @Override
    public boolean test(Player p) {
        if (this.classes.isEmpty()) {
            return true;
        }
        for (FabledClass classe : this.classes) {
            PlayerClass mainClass = Fabled.getData((OfflinePlayer)p).getMainClass();
            if (mainClass == null || mainClass.getData() != classe) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultDescription(Player p) {
        return Lang.RDClass.quickFormat("classes", String.join((CharSequence)(" " + Lang.Or.toString() + " "), () -> this.classes.stream().map(FabledClass::getName).iterator()));
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(this.classes.size() + " classes");
    }

    @Override
    public void itemClick(final QuestObjectClickEvent event) {
        new ListGUI<FabledClass>(Lang.INVENTORY_CLASSES_REQUIRED.toString(), DyeColor.GREEN, this.classes){

            @Override
            public ItemStack getObjectItemStack(FabledClass object) {
                return ItemUtils.loreAdd(object.getIcon(), this.createLoreBuilder(object).toLoreArray());
            }

            @Override
            public void createObject(final Function<FabledClass, ItemStack> callback) {
                new PagedGUI<FabledClass>(Lang.INVENTORY_CLASSES_LIST.toString(), DyeColor.PURPLE, Fabled.getClasses().values()){

                    @Override
                    public ItemStack getItemStack(FabledClass object) {
                        return object.getIcon();
                    }

                    @Override
                    public void click(FabledClass existing, ItemStack item, ClickType clickType) {
                        callback.apply(existing);
                    }
                }.open(this.player);
            }

            @Override
            public void finish(List<FabledClass> objects) {
                FabledClassRequirement.this.classes = objects;
                event.reopenGUI();
            }
        }.open(event.getPlayer());
    }

    @Override
    public AbstractRequirement clone() {
        return new FabledClassRequirement(this.getCustomDescription(), this.getCustomReason(), new ArrayList<FabledClass>(this.classes));
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        if (!this.classes.isEmpty()) {
            section.set("classes", this.classes.stream().map(FabledClass::getName).collect(Collectors.toList()));
        }
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        if (!section.contains("classes")) {
            return;
        }
        for (String s : section.getStringList("classes")) {
            FabledClass classe = (FabledClass)Fabled.getClasses().get(s.toLowerCase());
            if (classe == null) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Class with name " + s + " no longer exists.");
                continue;
            }
            this.classes.add(classe);
        }
    }
}

