/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.fabled;

import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ExpSource;

public class FabledXpReward
extends AbstractReward {
    public int exp = 0;

    public FabledXpReward() {
    }

    public FabledXpReward(String customDescription, int exp) {
        super(customDescription);
        this.exp = exp;
    }

    @Override
    public void give(RewardGiveContext context) {
        for (Player player : context.getQuester().getOnlinePlayers()) {
            Fabled.getData((OfflinePlayer)player).giveExp((double)this.exp, ExpSource.QUEST);
            context.addEarning(player, this);
        }
    }

    @Override
    public AbstractReward clone() {
        return new FabledXpReward(this.getCustomDescription(), this.exp);
    }

    @Override
    public String getDefaultDescription(Player p) {
        return this.getXpAmountString();
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescriptionAsValue(this.getXpAmountString());
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("xp_amount", this::getXpAmountString);
    }

    @NotNull
    private String getXpAmountString() {
        return Lang.AmountXp.quickFormat("xp_amount", this.exp);
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        Lang.XP_GAIN.send((CommandSender)event.getPlayer(), this);
        new TextEditor<Integer>(event.getPlayer(), event::cancel, obj -> {
            int old = this.exp;
            this.exp = obj;
            Lang.XP_EDITED.send((CommandSender)event.getPlayer(), PlaceholderRegistry.of("old_xp_amount", old).with(this));
            event.reopenGUI();
        }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start();
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("xp", (Object)this.exp);
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.exp = section.getInt("xp");
    }
}

