/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.factions;

import com.cryptomorin.xseries.XMaterial;
import com.massivecraft.factions.FactionsIndex;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.massivecore.store.EntityInternal;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class FactionRequirement
extends AbstractRequirement {
    public List<Faction> factions;

    public FactionRequirement() {
        this(null, null, new ArrayList<Faction>());
    }

    public FactionRequirement(String customDescription, String customReason, List<Faction> factions) {
        super(customDescription, customReason);
        this.factions = factions;
    }

    public void addFaction(Object faction) {
        this.factions.add((Faction)faction);
    }

    @Override
    public String getDefaultDescription(Player p) {
        return Lang.RDFaction.quickFormat("factions", String.join((CharSequence)(" " + Lang.Or.toString() + " "), () -> this.factions.stream().map(Faction::getName).iterator()));
    }

    @Override
    public boolean test(Player p) {
        if (this.factions.isEmpty()) {
            return true;
        }
        for (Faction fac : this.factions) {
            if (FactionsIndex.get().getFaction(MPlayer.get((Object)p)) != fac) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(this.factions.size() + " factions");
    }

    @Override
    public void itemClick(final QuestObjectClickEvent event) {
        new ListGUI<Faction>(Lang.INVENTORY_FACTIONS_REQUIRED.toString(), DyeColor.LIGHT_BLUE, this.factions){

            @Override
            public ItemStack getObjectItemStack(Faction object) {
                return ItemUtils.item(XMaterial.IRON_SWORD, object.getName(), this.createLoreBuilder(object).toLoreArray());
            }

            @Override
            public void createObject(final Function<Faction, ItemStack> callback) {
                new PagedGUI<Faction>(Lang.INVENTORY_FACTIONS_LIST.toString(), DyeColor.PURPLE, FactionColl.get().getAll()){

                    @Override
                    public ItemStack getItemStack(Faction object) {
                        return ItemUtils.item(XMaterial.IRON_SWORD, object.getName(), new String[0]);
                    }

                    @Override
                    public void click(Faction existing, ItemStack item, ClickType clickType) {
                        callback.apply(existing);
                    }
                }.open(this.player);
            }

            @Override
            public void finish(List<Faction> objects) {
                FactionRequirement.this.factions = objects;
                event.reopenGUI();
            }
        }.open(event.getPlayer());
    }

    @Override
    public AbstractRequirement clone() {
        return new FactionRequirement(this.getCustomDescription(), this.getCustomReason(), new ArrayList<Faction>(this.factions));
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("factions", this.factions.stream().map(EntityInternal::getId).collect(Collectors.toList()));
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        for (String s : section.getStringList("factions")) {
            if (!FactionColl.get().containsId((Object)s)) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Faction with ID " + s + " no longer exists.");
                continue;
            }
            this.factions.add((Faction)FactionColl.get().get((Object)s));
        }
    }
}

