/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.mcmmo;

import com.gmail.nossr50.api.ExperienceAPI;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.TargetNumberRequirement;
import fr.skytasul.quests.api.utils.ComparisonMethod;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class McMMOSkillRequirement
extends TargetNumberRequirement {
    public String skillName;

    public McMMOSkillRequirement() {
        this(null, null, 0.0, ComparisonMethod.GREATER_OR_EQUAL, null);
    }

    public McMMOSkillRequirement(String customDescription, String customReason, double target, ComparisonMethod comparison, String skillName) {
        super(customDescription, customReason, target, comparison);
        this.skillName = skillName;
    }

    @Override
    public double getPlayerTarget(Player p) {
        return ExperienceAPI.getLevel((Player)p, (String)this.skillName);
    }

    @Override
    protected String getPlaceholderName() {
        return "level";
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("skill_name", () -> this.skillName);
    }

    @Override
    protected String getDefaultReason(Player player) {
        return Lang.REQUIREMENT_SKILL.format((HasPlaceholders)this);
    }

    @Override
    public String getDefaultDescription(Player p) {
        return Lang.RDSkillLevel.format((HasPlaceholders)this);
    }

    @Override
    public Class<? extends Number> numberClass() {
        return Integer.class;
    }

    @Override
    public void sendHelpString(Player p) {
        Lang.CHOOSE_XP_REQUIRED.send((CommandSender)p);
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription("\u00a78Skill name: \u00a77" + this.skillName);
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        Lang.CHOOSE_SKILL_REQUIRED.send((CommandSender)event.getPlayer());
        new TextEditor<String>(event.getPlayer(), event::cancel, obj -> {
            this.skillName = obj;
            super.itemClick(event);
        }).useStrippedMessage().start();
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("skillName", (Object)this.skillName);
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.skillName = section.getString("skillName");
    }

    @Override
    public AbstractRequirement clone() {
        return new McMMOSkillRequirement(this.getCustomDescription(), this.getCustomReason(), this.target, this.comparison, this.skillName);
    }
}

