/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.mobs;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.MobFactory;
import fr.skytasul.quests.api.utils.MinecraftNames;
import fr.skytasul.quests.api.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.mineacademy.boss.api.BossAPI;
import org.mineacademy.boss.api.event.BossDeathEvent;
import org.mineacademy.boss.model.Boss;

public class BQBoss
implements MobFactory<Boss>,
Listener {
    private ItemStack item = ItemUtils.item(XMaterial.BLAZE_ROD, Lang.boss.toString(), new String[0]);

    @Override
    public String getID() {
        return "boss";
    }

    @Override
    public ItemStack getFactoryItem() {
        return this.item;
    }

    @Override
    public void itemClick(Player p, final Consumer<Boss> run) {
        new PagedGUI<Boss>("List of Bosses", DyeColor.ORANGE, BossAPI.getBosses(), null, x -> x.getName()){

            @Override
            public ItemStack getItemStack(Boss object) {
                return ItemUtils.item(Utils.mobItem(object.getType()), object.getName(), new String[0]);
            }

            @Override
            public void click(Boss existing, ItemStack item, ClickType clickType) {
                this.close();
                run.accept(existing);
            }
        }.open(p);
    }

    @Override
    public Boss fromValue(String value) {
        return BossAPI.getBoss((String)value);
    }

    @Override
    public boolean bukkitMobApplies(Boss first, Entity entity) {
        return BossAPI.getBoss((Entity)entity).getBoss().equals((Object)first);
    }

    @Override
    public String getValue(Boss data) {
        return data.getName();
    }

    @Override
    public String getName(Boss data) {
        return data.getName();
    }

    @Override
    public EntityType getEntityType(Boss data) {
        return data.getType();
    }

    @Override
    public List<String> getDescriptiveLore(Boss data) {
        return Arrays.asList(Lang.EntityType.quickFormat("entity_type", MinecraftNames.getEntityName(data.getType())), "\u00a78Health: \u00a77\u00a7l" + data.getDefaultHealth());
    }

    @EventHandler
    public void onBossDeath(BossDeathEvent e) {
        Entity killer = Utils.getEntityKiller(e.getEntity());
        if (killer == null) {
            return;
        }
        this.callEvent((Event)e, e.getBoss(), (Entity)e.getEntity(), killer);
    }
}

