/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.mobs;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.mobs.LeveledMobFactory;
import fr.skytasul.quests.api.utils.MinecraftNames;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BQLevelledMobs
implements LeveledMobFactory<EntityType> {
    private final NamespacedKey levelKey;
    private final ItemStack item = ItemUtils.item(XMaterial.CHICKEN_SPAWN_EGG, "\u00a7eLevelledMobs", new String[0]);

    public BQLevelledMobs() {
        this.levelKey = new NamespacedKey(Bukkit.getPluginManager().getPlugin("LevelledMobs"), "level");
    }

    @Override
    public String getID() {
        return "levelledMobs";
    }

    @Override
    public ItemStack getFactoryItem() {
        return this.item;
    }

    @Override
    public void itemClick(Player p, Consumer<EntityType> run) {
        QuestsPlugin.getPlugin().getGuiManager().getFactory().createEntityTypeSelection(run, x -> x != null && x.isAlive()).open(p);
    }

    @Override
    public double getMobLevel(EntityType type, Entity entity) {
        Integer level = (Integer)entity.getPersistentDataContainer().get(this.levelKey, PersistentDataType.INTEGER);
        return level == null ? 0.0 : (double)level.intValue();
    }

    @Override
    public EntityType fromValue(String value) {
        return EntityType.valueOf((String)value);
    }

    @Override
    public String getValue(EntityType data) {
        return data.name();
    }

    @Override
    public String getName(EntityType data) {
        return MinecraftNames.getEntityName(data);
    }

    @Override
    public EntityType getEntityType(EntityType data) {
        return data;
    }

    @Override
    public boolean bukkitMobApplies(@NotNull EntityType first, @NotNull Entity entity) {
        return entity.getType() == first;
    }
}

