/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.mobs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.mobs.MobStacker;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import uk.antiperson.stackmob.events.StackDeathEvent;

public class BQStackMob
implements Listener,
MobStacker {
    private final Cache<Integer, Integer> killedStacks = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();

    private BQStackMob() {
    }

    public static void initialize() {
        BQStackMob stacker = new BQStackMob();
        QuestsAPI.getAPI().registerMobStacker(stacker);
        Bukkit.getPluginManager().registerEvents((Listener)stacker, (Plugin)QuestsPlugin.getPlugin());
    }

    @EventHandler
    public void onStackDeath(StackDeathEvent event) {
        this.killedStacks.put((Object)event.getStackEntity().getEntity().getEntityId(), (Object)event.getDeathStep());
    }

    @Override
    public int getEntityStackSize(@NotNull Entity entity) {
        Integer amount = (Integer)this.killedStacks.getIfPresent((Object)entity.getEntityId());
        return amount == null ? 1 : amount;
    }
}

