/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.mobs;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.InventoryClear;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.MobFactory;
import fr.skytasul.quests.api.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.MobType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class CitizensFactory
implements MobFactory<NPC>,
Listener {
    private final ItemStack item = ItemUtils.item(XMaterial.STICK, Lang.selectNPC.toString(), new String[0]);

    @Override
    public String getID() {
        return "citizensNPC";
    }

    @Override
    public ItemStack getFactoryItem() {
        return this.item;
    }

    @Override
    public void itemClick(Player p, Consumer<NPC> run) {
        Lang.SELECT_KILL_NPC.send((CommandSender)p);
        new CitizensNpcClickEditor(p, () -> run.accept(null), run).start();
    }

    @Override
    public NPC fromValue(String value) {
        return CitizensAPI.getNPCRegistry().getById(Integer.parseInt(value));
    }

    @Override
    public boolean bukkitMobApplies(NPC first, Entity entity) {
        return first.isSpawned() && first.getEntity().equals((Object)entity);
    }

    @Override
    public String getValue(NPC data) {
        return Integer.toString(data.getId());
    }

    @Override
    public String getName(NPC data) {
        return data.getName();
    }

    @Override
    public EntityType getEntityType(NPC data) {
        return ((MobType)data.getOrAddTrait(MobType.class)).getType();
    }

    @Override
    public List<String> getDescriptiveLore(NPC data) {
        return Arrays.asList("\u00a78NPC ID: \u00a77\u00a7l" + data.getId());
    }

    @EventHandler
    public void onNPCKilled(NPCDeathEvent e) {
        LivingEntity en = (LivingEntity)e.getNPC().getEntity();
        Entity killer = Utils.getEntityKiller(en);
        if (killer == null) {
            return;
        }
        this.callEvent((Event)e, e.getNPC(), (Entity)en, killer);
    }

    private class CitizensNpcClickEditor
    extends InventoryClear
    implements Listener {
        private final Consumer<NPC> run;

        private CitizensNpcClickEditor(Player p, Runnable cancel, Consumer<NPC> run) {
            super(p, cancel);
            this.run = run;
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onNPCClick(NPCRightClickEvent e) {
            if (e.getClicker() != this.player) {
                return;
            }
            e.setCancelled(true);
            this.stop();
            this.run.accept(e.getNPC());
        }

        @Override
        public void begin() {
            super.begin();
            Lang.NPC_EDITOR_ENTER.send((CommandSender)this.player);
        }
    }
}

