/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.mobs;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.LeveledMobFactory;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.utils.Utils;
import io.lumine.xikage.mythicmobs.api.bukkit.events.MythicMobDeathEvent;
import io.lumine.xikage.mythicmobs.mobs.ActiveMob;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import io.lumine.xikage.mythicmobs.skills.placeholders.parsers.PlaceholderString;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class MythicMobs
implements LeveledMobFactory<MythicMob>,
Listener {
    private ItemStack item = ItemUtils.item(XMaterial.BLAZE_POWDER, Lang.mythicMob.toString(), new String[0]);

    @Override
    public String getID() {
        return "mythicMobs";
    }

    @Override
    public ItemStack getFactoryItem() {
        return this.item;
    }

    @Override
    public void itemClick(Player p, final Consumer<MythicMob> run) {
        new PagedGUI<MythicMob>("List of MythicMobs", DyeColor.PINK, io.lumine.xikage.mythicmobs.MythicMobs.inst().getMobManager().getMobTypes(), null, MythicMob::getInternalName){

            @Override
            public ItemStack getItemStack(MythicMob object) {
                XMaterial mobItem;
                try {
                    mobItem = Utils.mobItem(MythicMobs.this.getEntityType(object));
                }
                catch (Exception ex) {
                    mobItem = XMaterial.SPONGE;
                    QuestsPlugin.getPlugin().getLoggerExpanded().warning("Unknow entity type for MythicMob " + object.getInternalName(), ex);
                }
                return ItemUtils.item(mobItem, object.getInternalName(), new String[0]);
            }

            @Override
            public void click(MythicMob existing, ItemStack item, ClickType clickType) {
                this.close();
                run.accept(existing);
            }
        }.sortValues(MythicMob::getInternalName).open(p);
    }

    @Override
    public MythicMob fromValue(String value) {
        return io.lumine.xikage.mythicmobs.MythicMobs.inst().getMobManager().getMythicMob(value);
    }

    @Override
    public boolean bukkitMobApplies(MythicMob first, Entity entity) {
        return io.lumine.xikage.mythicmobs.MythicMobs.inst().getMobManager().getActiveMob(entity.getUniqueId()).map(mob -> mob.getType().equals((Object)first)).orElse(false);
    }

    @Override
    public double getMobLevel(MythicMob type, Entity entity) {
        return ((ActiveMob)io.lumine.xikage.mythicmobs.MythicMobs.inst().getMobManager().getActiveMob(entity.getUniqueId()).get()).getLevel();
    }

    @Override
    public String getValue(MythicMob data) {
        return data.getInternalName();
    }

    @Override
    public String getName(MythicMob data) {
        try {
            PlaceholderString displayName = data.getDisplayName();
            if (displayName != null) {
                return displayName.get();
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return data.getInternalName();
    }

    @Override
    public EntityType getEntityType(MythicMob data) {
        EntityType type;
        String typeName = data.getEntityType() == null ? (data.getMythicEntity() == null ? null : data.getMythicEntity().getClass().getSimpleName().substring(6)) : data.getEntityType().toUpperCase();
        if (typeName.contains("BABY_")) {
            typeName = typeName.substring(5);
        }
        if (typeName.equalsIgnoreCase("MPET")) {
            typeName = data.getConfig().getString("MPet.Anchor");
        }
        if ((type = EntityType.fromName((String)typeName)) == null) {
            try {
                type = EntityType.valueOf((String)typeName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return type;
    }

    @Override
    public List<String> getDescriptiveLore(MythicMob data) {
        try {
            return Arrays.asList(QuestOption.formatDescription("Base Health: " + data.getHealth().get()), QuestOption.formatDescription("Base Damage: " + data.getDamage().get()), QuestOption.formatDescription("Base Armor: " + data.getArmor().get()));
        }
        catch (NoSuchMethodError e) {
            return Arrays.asList("\u00a7cError when retrieving mob informations", "\u00a7c-> \u00a7oPlease update MythicMobs");
        }
    }

    @EventHandler
    public void onMythicDeath(MythicMobDeathEvent e) {
        if (e.getKiller() == null) {
            return;
        }
        this.callEvent((Event)e, e.getMob().getType(), e.getEntity(), (Entity)e.getKiller());
    }
}

