/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.mobs;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.events.internal.BQMobDeathEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.LeveledMobFactory;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.integrations.IntegrationsConfiguration;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class MythicMobs5
implements LeveledMobFactory<MythicMob>,
Listener {
    private ItemStack item = ItemUtils.item(XMaterial.BLAZE_POWDER, Lang.mythicMob.toString(), new String[0]);

    @Override
    public String getID() {
        return "mythicMobs";
    }

    @Override
    public ItemStack getFactoryItem() {
        return this.item;
    }

    @Override
    public void itemClick(Player p, final Consumer<MythicMob> run) {
        new PagedGUI<MythicMob>("List of MythicMobs", DyeColor.PINK, MythicBukkit.inst().getMobManager().getMobTypes(), null, MythicMob::getInternalName){

            @Override
            public ItemStack getItemStack(MythicMob object) {
                XMaterial mobItem;
                try {
                    mobItem = Utils.mobItem(MythicMobs5.this.getEntityType(object));
                }
                catch (Exception ex) {
                    mobItem = XMaterial.SPONGE;
                    QuestsPlugin.getPlugin().getLoggerExpanded().warning("Unknow entity type for MythicMob " + object.getInternalName(), ex);
                }
                return ItemUtils.item(mobItem, object.getInternalName(), new String[0]);
            }

            @Override
            public void click(MythicMob existing, ItemStack item, ClickType clickType) {
                this.close();
                run.accept(existing);
            }
        }.sortValues(MythicMob::getInternalName).open(p);
    }

    @Override
    public MythicMob fromValue(String value) {
        return MythicBukkit.inst().getMobManager().getMythicMob(value).orElse(null);
    }

    @Override
    public boolean bukkitMobApplies(MythicMob first, Entity entity) {
        return MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId()).map(mob -> mob.getType().equals((Object)first)).orElse(false);
    }

    @Override
    public double getMobLevel(MythicMob type, Entity entity) {
        return ((ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId()).get()).getLevel();
    }

    @Override
    public String getValue(MythicMob data) {
        return data.getInternalName();
    }

    @Override
    public String getName(MythicMob data) {
        PlaceholderString displayName = data.getDisplayName();
        if (displayName != null) {
            return QuestsPlugin.getPlugin().isRunningPaper() ? Text.toLegacy((Component)Text.parse((String)displayName.get())) : displayName.get();
        }
        return data.getInternalName();
    }

    @Override
    public EntityType getEntityType(MythicMob data) {
        EntityType type;
        String typeName = data.getEntityType() == null ? (data.getMythicEntity() == null ? null : data.getMythicEntity().getClass().getSimpleName().substring(6)) : Objects.toString(data.getEntityType()).toUpperCase();
        if (typeName == null) {
            return null;
        }
        if (typeName.contains("BABY_")) {
            typeName = typeName.substring(5);
        }
        if (typeName.equalsIgnoreCase("MPET")) {
            typeName = data.getConfig().getString("MPet.Anchor");
        }
        if ((type = EntityType.fromName((String)typeName)) == null) {
            try {
                type = EntityType.valueOf((String)typeName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return type;
    }

    @Override
    public List<String> getDescriptiveLore(MythicMob data) {
        try {
            return Arrays.asList(QuestOption.formatDescription("Base Health: " + Objects.toString(data.getHealth())), QuestOption.formatDescription("Base Damage: " + Objects.toString(data.getDamage())), QuestOption.formatDescription("Base Armor: " + Objects.toString(data.getArmor())));
        }
        catch (Throwable ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("An error occurred while showing mob description", ex);
            return Arrays.asList("\u00a7cError when retrieving mob informations");
        }
    }

    @EventHandler
    public void onMythicDeath(MythicMobDeathEvent e) {
        if (e.getKiller() == null) {
            return;
        }
        this.callEvent((Event)e, e.getMob().getType(), e.getEntity(), (Entity)e.getKiller());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onBqMobDeath(BQMobDeathEvent event) {
        if (!IntegrationsConfiguration.getConfiguration().mythicMobsPetKillToOwner()) {
            return;
        }
        Optional mobOpt = MythicBukkit.inst().getMobManager().getActiveMob(event.getKiller().getUniqueId());
        if (mobOpt.isEmpty()) {
            return;
        }
        try {
            if (!((ActiveMob)mobOpt.get()).getOwnerUUID().isPresent()) {
                return;
            }
        }
        catch (NoSuchMethodError ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("The 'mythicmobs.count kill for pet owner' option is not compatible with your MythicMobs version. Please disable it or update MythicMobs.");
            return;
        }
        Player owner = Bukkit.getPlayer((UUID)((UUID)((ActiveMob)mobOpt.get()).getOwnerUUID().get()));
        if (owner == null) {
            return;
        }
        event.setKiller((Entity)owner);
    }
}

