/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.npcs;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.npcs.BqInternalNpc;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import fr.skytasul.quests.api.npcs.NpcClickType;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.MythicEntityType;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMobInteractEvent;
import io.lumine.mythic.bukkit.events.MythicReloadedEvent;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BQMythicMobs5Npcs
implements BqInternalNpcFactory,
Listener {
    @Override
    public int getTimeToWaitForNPCs() {
        return 0;
    }

    @Override
    public boolean isNPC(@NotNull Entity entity) {
        return MythicBukkit.inst().getMobManager().isMythicMob(entity);
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull String> getIDs() {
        return MythicBukkit.inst().getMobManager().getMobNames();
    }

    @Override
    @Nullable
    public BqInternalNpc fetchNPC(String id) {
        return this.getMythicMobForInternalName(id).map(x$0 -> new BQMythicMobs5Npc((MythicMob)x$0)).orElse(null);
    }

    private Optional<MythicMob> getMythicMobForInternalName(@NotNull String internalName) {
        Optional mobOpt = MythicBukkit.inst().getMobManager().getMythicMob(internalName);
        if (mobOpt.isPresent()) {
            return mobOpt;
        }
        MythicEntityType met = MythicEntityType.get((String)internalName);
        if (met != null) {
            return MythicBukkit.inst().getMobManager().getMythicMob(met.toString());
        }
        return Optional.empty();
    }

    @EventHandler
    public void onMythicInteract(MythicMobInteractEvent event) {
        String internalName = event.getActiveMobType().getInternalName();
        if (!this.getMythicMobForInternalName(internalName).isPresent()) {
            throw new IllegalStateException("Mob " + internalName + " does not actually exist");
        }
        this.npcClicked(new MythicInteractEventProxy(event), internalName, event.getPlayer(), NpcClickType.RIGHT);
    }

    @EventHandler
    public void onMythicReloaded(MythicReloadedEvent event) {
        this.npcsReloaded();
    }

    private static class MythicInteractEventProxy
    extends Event
    implements Cancellable {
        @NotNull
        private final MythicMobInteractEvent event;

        public MythicInteractEventProxy(@NotNull MythicMobInteractEvent event) {
            this.event = event;
        }

        public boolean isCancelled() {
            return this.event.isCancelled();
        }

        public void setCancelled(boolean cancel) {
            if (cancel) {
                this.event.setCancelled();
            }
        }

        @NotNull
        public HandlerList getHandlers() {
            return null;
        }
    }

    private class BQMythicMobs5Npc
    implements BqInternalNpc {
        @NotNull
        private final MythicMob mob;

        public BQMythicMobs5Npc(MythicMob mob) {
            this.mob = mob;
        }

        @Override
        public String getInternalId() {
            return this.mob.getInternalName();
        }

        @Override
        @NotNull
        public String getName() {
            return this.mob.getDisplayName() == null ? this.mob.getInternalName() : this.mob.getDisplayName().get();
        }

        @NotNull
        private Optional<ActiveMob> getOneActiveMob() {
            ActiveMob oneActiveMob = null;
            for (ActiveMob activeMob : MythicBukkit.inst().getMobManager().getActiveMobs()) {
                if (activeMob.isDead() || !activeMob.getType().equals((Object)this.mob)) continue;
                if (oneActiveMob == null) {
                    oneActiveMob = activeMob;
                    continue;
                }
                QuestsPlugin.getPlugin().getLogger().warning("Found two active mobs for the same Mythic Mobs NPC " + this.mob.getInternalName());
                break;
            }
            return Optional.ofNullable(oneActiveMob);
        }

        @Override
        public boolean isSpawned() {
            return this.getOneActiveMob().isPresent();
        }

        @Override
        @Nullable
        public Entity getEntity() {
            return this.getOneActiveMob().map(mob -> mob.getEntity().getBukkitEntity()).orElse(null);
        }

        @Override
        @Nullable
        public Location getLocation() {
            return this.getOneActiveMob().map(mob -> BukkitAdapter.adapt((AbstractLocation)mob.getLocation())).orElse(null);
        }

        @Override
        public boolean setNavigationPaused(boolean paused) {
            return false;
        }
    }
}

