/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.npcs;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.Quest;
import java.util.function.BiPredicate;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;

public class BQSentinel {
    private BQSentinel() {
    }

    public static void initialize() {
        new BQSentinelIntegration();
    }

    private static class BQSentinelIntegration
    extends SentinelIntegration {
        public BQSentinelIntegration() {
            SentinelPlugin.instance.registerIntegration((SentinelIntegration)this);
        }

        public String getTargetHelp() {
            return "quest_in:QUEST_ID, quest_finished:QUEST_ID";
        }

        public String[] getTargetPrefixes() {
            return new String[]{"quest_in", "quest_finished"};
        }

        public boolean isTarget(LivingEntity ent, String prefix, String value) {
            switch (prefix) {
                case "quest_in": {
                    return this.test(ent, value, Quest::hasStarted);
                }
                case "quest_finished": {
                    return this.test(ent, value, Quest::hasFinished);
                }
            }
            return false;
        }

        private boolean test(LivingEntity ent, String value, BiPredicate<Quest, Quester> test) {
            PlayerQuester acc;
            if (ent instanceof Player && (acc = PlayerManager.getPlayerAccount((Player)ent)) != null) {
                try {
                    int questID = Integer.parseInt(value);
                    Quest quest = QuestsAPI.getAPI().getQuestsManager().getQuest(questID);
                    return quest != null && test.test(quest, acc);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

