/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.npcs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.npcs.BqInternalNpc;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import fr.skytasul.quests.api.npcs.NpcClickType;
import io.github.gonalez.znpcs.ServersNPC;
import io.github.gonalez.znpcs.configuration.ConfigurationConstants;
import io.github.gonalez.znpcs.npc.NPC;
import io.github.gonalez.znpcs.npc.NPCModel;
import io.github.gonalez.znpcs.npc.NPCType;
import io.github.gonalez.znpcs.npc.event.NPCInteractEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BQServerNPCs
implements BqInternalNpcFactory.BqInternalNpcFactoryCreatable,
Listener {
    private Cache<Integer, Boolean> cachedNpcs = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Override
    public int getTimeToWaitForNPCs() {
        return 45;
    }

    @Override
    public Collection<String> getIDs() {
        return NPC.all().stream().map(x -> Integer.toString(x.getNpcPojo().getId())).collect(Collectors.toList());
    }

    @Override
    public boolean isNPC(Entity entity) {
        Boolean result = (Boolean)this.cachedNpcs.getIfPresent((Object)entity.getEntityId());
        if (result == null) {
            result = NPC.all().stream().anyMatch(npc1 -> npc1.getEntityID() == entity.getEntityId());
            this.cachedNpcs.put((Object)entity.getEntityId(), (Object)result);
        }
        return result;
    }

    @Override
    public BqInternalNpc fetchNPC(String internalId) {
        NPC npc = NPC.find((int)Integer.parseInt(internalId));
        return npc == null ? null : new BQServerNPC(npc);
    }

    @Override
    public boolean isValidEntityType(EntityType type) {
        return Arrays.stream(NPCType.values()).map(Enum::name).anyMatch(name -> name.equals(type.name()));
    }

    @Override
    @NotNull
    public BqInternalNpc create(Location location, EntityType type, String name, @Nullable String skin) {
        List ids = ConfigurationConstants.NPC_LIST.stream().map(NPCModel::getId).collect(Collectors.toList());
        int id = ids.size();
        while (ids.contains(id)) {
            ++id;
        }
        NPC npc = ServersNPC.createNPC((int)id, (NPCType)NPCType.valueOf((String)type.name()), (Location)location, (String)name);
        npc.getNpcPojo().getFunctions().put("look", true);
        if (skin != null) {
            QuestsPlugin.getPlugin().getLogger().warning("Cannot set skin to a ZNPC");
        }
        return new BQServerNPC(npc);
    }

    @EventHandler
    public void onInteract(NPCInteractEvent e) {
        this.npcClicked(null, Integer.toString(e.getNpc().getNpcPojo().getId()), e.getPlayer(), NpcClickType.of(e.isLeftClick(), e.getPlayer().isSneaking()));
    }

    public static class BQServerNPC
    implements BqInternalNpc {
        private final NPC npc;

        private BQServerNPC(NPC npc) {
            this.npc = npc;
        }

        public NPC getServerNPC() {
            return this.npc;
        }

        @Override
        public String getInternalId() {
            return Integer.toString(this.npc.getNpcPojo().getId());
        }

        @Override
        public String getName() {
            return this.npc.getNpcPojo().getHologramLines().isEmpty() ? "ID: " + this.npc.getNpcPojo().getId() : (String)this.npc.getNpcPojo().getHologramLines().get(0);
        }

        @Override
        public boolean isSpawned() {
            return this.npc.getBukkitEntity() != null;
        }

        @Override
        public Entity getEntity() {
            return (Entity)this.npc.getBukkitEntity();
        }

        @Override
        public Location getLocation() {
            return this.npc.getLocation();
        }

        @Override
        public boolean setNavigationPaused(boolean paused) {
            return true;
        }
    }
}

