/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.npcs;

import fr.skytasul.quests.api.npcs.BqInternalNpc;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import fr.skytasul.quests.api.npcs.NpcClickType;
import java.util.Collection;
import lol.pyr.znpcsplus.api.NpcApiProvider;
import lol.pyr.znpcsplus.api.event.NpcInteractEvent;
import lol.pyr.znpcsplus.api.interaction.InteractionType;
import lol.pyr.znpcsplus.api.npc.NpcEntry;
import lol.pyr.znpcsplus.util.NpcLocation;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BQZNPCsPlus
implements BqInternalNpcFactory.BqInternalNpcFactoryCreatable,
Listener {
    @Override
    public int getTimeToWaitForNPCs() {
        return 45;
    }

    @Override
    public Collection<String> getIDs() {
        return NpcApiProvider.get().getNpcRegistry().getAllPlayerMadeIds();
    }

    @Override
    public boolean isNPC(Entity entity) {
        return false;
    }

    @Override
    public BqInternalNpc fetchNPC(String internalId) {
        NpcEntry npc = NpcApiProvider.get().getNpcRegistry().getById(internalId);
        return npc == null ? null : new BQZnpcPlus(npc);
    }

    @Override
    public boolean isValidEntityType(EntityType type) {
        return NpcApiProvider.get().getNpcTypeRegistry().getByName(type.name()) != null;
    }

    @Override
    @NotNull
    public BqInternalNpc create(@NotNull Location location, @NotNull EntityType type, @NotNull String name, @Nullable String skin) {
        String id;
        int i = 1;
        while (true) {
            id = name + "-" + i;
            if (NpcApiProvider.get().getNpcRegistry().getById(id) == null) break;
            ++i;
        }
        NpcEntry npc = NpcApiProvider.get().getNpcRegistry().create(id, location.getWorld(), NpcApiProvider.get().getNpcTypeRegistry().getByName(type.name()), new NpcLocation(location));
        npc.enableEverything();
        return new BQZnpcPlus(npc);
    }

    @EventHandler
    public void onInteract(NpcInteractEvent e) {
        this.npcClicked(null, e.getEntry().getId(), e.getPlayer(), NpcClickType.of(e.getClickType() == InteractionType.LEFT_CLICK, e.getPlayer().isSneaking()));
    }

    public static class BQZnpcPlus
    implements BqInternalNpc {
        private final NpcEntry npc;

        private BQZnpcPlus(NpcEntry npc) {
            this.npc = npc;
        }

        @Override
        public String getInternalId() {
            return this.npc.getId();
        }

        @Override
        public String getName() {
            return this.npc.getNpc().getHologram().lineCount() == 0 ? "ID: " + this.npc.getId() : this.npc.getNpc().getHologram().getLine(0);
        }

        @Override
        public boolean isSpawned() {
            return this.npc.getNpc().isEnabled();
        }

        @Override
        public Entity getEntity() {
            return null;
        }

        @Override
        public Location getLocation() {
            return this.npc.getNpc().getLocation().toBukkitLocation(this.npc.getNpc().getWorld());
        }

        @Override
        public boolean setNavigationPaused(boolean paused) {
            return true;
        }
    }
}

