/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.placeholders;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.utils.ComparisonMethod;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import fr.skytasul.quests.integrations.placeholders.QuestsPlaceholders;
import java.math.BigDecimal;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaceholderRequirement
extends AbstractRequirement {
    private String rawPlaceholder;
    private PlaceholderExpansion hook;
    private String params;
    private String value;
    private ComparisonMethod comparison;
    private boolean parseValue = false;

    public PlaceholderRequirement() {
        this(null, null, null, null, ComparisonMethod.EQUALS);
    }

    public PlaceholderRequirement(String customDescription, String customReason, String placeholder, String value, ComparisonMethod comparison) {
        super(customDescription, customReason);
        if (placeholder != null) {
            this.setPlaceholder(placeholder);
        }
        this.value = value;
        this.comparison = comparison;
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("placeholder", () -> this.rawPlaceholder);
        placeholders.register("target_value", () -> this.value);
        placeholders.register("comparison", () -> Character.toString(this.comparison.getSymbol()));
        placeholders.register("parse_value", () -> Boolean.toString(this.parseValue));
    }

    @Override
    public boolean test(Player p) {
        if (this.hook == null) {
            return false;
        }
        String request = this.hook.onRequest((OfflinePlayer)p, this.params);
        if (this.comparison.isNumberOperation()) {
            BigDecimal dec1 = new BigDecimal(this.value);
            try {
                BigDecimal dec2 = new BigDecimal(request);
                int signum = dec2.subtract(dec1).signum();
                if (signum == 0) {
                    return this.comparison.isEqualOperation();
                }
                if (signum == 1) {
                    return this.comparison == ComparisonMethod.GREATER || this.comparison == ComparisonMethod.GREATER_OR_EQUAL;
                }
                if (signum == -1) {
                    return this.comparison == ComparisonMethod.LESS || this.comparison == ComparisonMethod.LESS_OR_EQUAL;
                }
            }
            catch (NumberFormatException e) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Cannot parse placeholder " + this.rawPlaceholder + " for player " + p.getName() + ": got " + request + ", which is not a number. (" + this.debugName() + ")");
            }
            return false;
        }
        if (this.comparison == ComparisonMethod.DIFFERENT) {
            return !this.value.equals(request);
        }
        String value = this.value;
        if (this.parseValue) {
            value = MessageUtils.finalFormat(value, null, PlaceholdersContext.of(p, true, null));
        }
        return value.equals(request);
    }

    @Override
    public boolean isValid() {
        return this.hook != null;
    }

    @Override
    protected String getInvalidReason() {
        return "unknown placeholder " + this.rawPlaceholder;
    }

    public void setPlaceholder(String placeholder) {
        this.rawPlaceholder = placeholder;
        int index = placeholder.indexOf("_");
        if (index == -1) {
            this.hook = null;
            this.params = placeholder;
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Usage of invalid placeholder " + placeholder);
        } else {
            String identifier = placeholder.substring(0, index);
            this.hook = PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().getExpansion(identifier);
            this.params = placeholder.substring(index + 1);
            if (this.hook == null) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Cannot find PlaceholderAPI expansion for " + this.rawPlaceholder);
                QuestsPlaceholders.waitForExpansion(identifier, expansion -> {
                    this.hook = expansion;
                    QuestsPlugin.getPlugin().getLoggerExpanded().debug("Found " + this.rawPlaceholder + " from callback");
                });
            }
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPlaceholder() {
        return this.rawPlaceholder;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("placeholder", (Object)this.rawPlaceholder);
        section.set("value", (Object)this.value);
        section.set("comparison", (Object)this.comparison.name());
        section.set("parseValue", (Object)this.parseValue);
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.setPlaceholder(section.getString("placeholder"));
        this.value = section.getString("value");
        if (section.contains("comparison")) {
            this.comparison = ComparisonMethod.valueOf(section.getString("comparison"));
        }
        if (section.contains("parseValue")) {
            this.parseValue = section.getBoolean("parseValue");
        }
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(QuestOption.formatNullableValue(this.rawPlaceholder));
        loreBuilder.addDescription(this.comparison.getTitle().quickFormat("number", this.value));
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        Lang.CHOOSE_PLACEHOLDER_REQUIRED_IDENTIFIER.send((CommandSender)event.getPlayer());
        new TextEditor<String>(event.getPlayer(), event::cancel, id -> {
            this.setPlaceholder((String)id);
            Lang.CHOOSE_PLACEHOLDER_REQUIRED_VALUE.send((CommandSender)event.getPlayer(), this);
            new TextEditor<String>(event.getPlayer(), () -> {
                if (this.value == null) {
                    event.getGUI().remove(this);
                }
                event.reopenGUI();
            }, value -> {
                this.value = value;
                try {
                    new BigDecimal((String)value);
                    Lang.COMPARISON_TYPE.send((CommandSender)event.getPlayer(), PlaceholderRegistry.of("available", ComparisonMethod.getComparisonParser().getNames(), "default", ComparisonMethod.EQUALS.name().toLowerCase()).with(this));
                    new TextEditor<ComparisonMethod>(event.getPlayer(), null, comp -> {
                        this.comparison = comp == null ? ComparisonMethod.EQUALS : comp;
                        event.reopenGUI();
                    }, ComparisonMethod.getComparisonParser()).passNullIntoEndConsumer().start();
                }
                catch (NumberFormatException __) {
                    event.reopenGUI();
                }
            }).start();
        }).useStrippedMessage().start();
    }

    @Override
    public AbstractRequirement clone() {
        return new PlaceholderRequirement(this.getCustomDescription(), this.getCustomReason(), this.rawPlaceholder, this.value, this.comparison);
    }
}

