/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.placeholders;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.clip.placeholderapi.events.ExpansionRegisterEvent;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class QuestsPlaceholders
extends PlaceholderExpansion
implements Listener {
    private static QuestsPlaceholders placeholders;
    private final int lineLength;
    private final int changeTime;
    private final String splitFormat;
    private final String inlineFormat;
    private BukkitTask task;
    private Map<Player, PlayerPlaceholderData> players = new HashMap<Player, PlayerPlaceholderData>();
    private ReentrantLock playersLock = new ReentrantLock();
    private List<Map.Entry<String, Consumer<PlaceholderExpansion>>> waitingExpansions = new ArrayList<Map.Entry<String, Consumer<PlaceholderExpansion>>>();

    private QuestsPlaceholders(ConfigurationSection placeholderConfig) {
        this.lineLength = placeholderConfig.getInt("lineLength");
        this.changeTime = placeholderConfig.getInt("changeTime");
        this.splitFormat = placeholderConfig.getString("splitPlaceholderFormat");
        this.inlineFormat = placeholderConfig.getString("inlinePlaceholderFormat");
    }

    public static void registerPlaceholders(ConfigurationSection placeholderConfig) {
        placeholders = new QuestsPlaceholders(placeholderConfig);
        placeholders.register();
        Bukkit.getPluginManager().registerEvents((Listener)placeholders, (Plugin)QuestsPlugin.getPlugin());
        QuestsPlugin.getPlugin().getLoggerExpanded().info("Placeholders registered !");
    }

    public static void waitForExpansion(String identifier, Consumer<PlaceholderExpansion> callback) {
        QuestsPlaceholders.placeholders.waitingExpansions.add(new AbstractMap.SimpleEntry<String, Consumer<PlaceholderExpansion>>(identifier, callback));
    }

    public String getAuthor() {
        return QuestsPlugin.getPlugin().getDescription().getAuthors().toString();
    }

    public String getIdentifier() {
        return "beautyquests";
    }

    public String getVersion() {
        return QuestsPlugin.getPlugin().getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public List<String> getPlaceholders() {
        return Arrays.asList("total_amount", "quest_restartable_ID", "player_inprogress_amount", "player_finished_amount", "player_finished_total_amount", "started", "started_ordered", "started_ordered_X", "advancement_ID", "advancement_ID_raw", "player_quest_finished_ID", "started_id_list");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onRequest(OfflinePlayer off, String identifier) {
        if (identifier.equals("total_amount")) {
            return "" + QuestsAPI.getAPI().getQuestsManager().getQuests().size();
        }
        if (identifier.startsWith("quest_restartable_")) {
            String sid = identifier.substring(18);
            try {
                Quest qu = QuestsAPI.getAPI().getQuestsManager().getQuest(Integer.parseInt(sid));
                if (qu == null) {
                    return "\u00a7c\u00a7lError: unknown quest \u00a7o" + sid;
                }
                return Boolean.toString(qu.isRepeatable());
            }
            catch (NumberFormatException ex) {
                return "\u00a7c\u00a7lError: \u00a7o" + sid;
            }
        }
        if (!off.isOnline()) {
            return "\u00a7cerror: offline";
        }
        Player p = off.getPlayer();
        PlayerQuester quester = PlayerManager.getPlayerAccount(p);
        if (quester == null) {
            return "\u00a7cdatas not loaded";
        }
        if (identifier.equals("player_inprogress_amount")) {
            return Long.toString(quester.getDataHolder().getAllQuestsData().stream().filter(QuesterQuestData::hasStarted).count());
        }
        if (identifier.equals("player_finished_amount")) {
            return Long.toString(quester.getDataHolder().getAllQuestsData().stream().filter(QuesterQuestData::hasFinishedOnce).count());
        }
        if (identifier.equals("player_finished_total_amount")) {
            return Integer.toString(quester.getDataHolder().getAllQuestsData().stream().mapToInt(QuesterQuestData::getTimesFinished).sum());
        }
        if (identifier.equals("started_id_list")) {
            return quester.getDataHolder().getAllQuestsData().stream().filter(QuesterQuestData::hasStarted).map(x -> Integer.toString(x.getQuestId())).collect(Collectors.joining(";"));
        }
        if (identifier.equals("started")) {
            return quester.getDataHolder().getAllQuestsData().stream().filter(QuesterQuestData::hasStarted).map(QuesterQuestData::getQuest).filter(Objects::nonNull).filter(Quest::isScoreboardEnabled).map(quest -> {
                String desc = quest.getDescriptionLine(quester, DescriptionSource.PLACEHOLDER);
                return this.inlineFormat.replace("{questName}", quest.getName()).replace("{questDescription}", desc);
            }).collect(Collectors.joining("\n"));
        }
        if (identifier.startsWith("started_ordered")) {
            String after = identifier.substring(15);
            if (this.task == null) {
                this.launchTask();
            }
            this.playersLock.lock();
            try {
                boolean noSplit;
                int i;
                PlayerPlaceholderData data2;
                block46: {
                    String ex2;
                    data2 = this.players.get(p);
                    if (data2 == null) {
                        data2 = new PlayerPlaceholderData(quester);
                        this.players.put(p, data2);
                    }
                    if (data2.left.isEmpty()) {
                        data2.left = QuestsAPI.getAPI().getQuestsManager().getQuestsStarted(data2.acc, false, true);
                    } else {
                        QuestsAPI.getAPI().getQuestsManager().updateQuestsStarted(quester, true, data2.left);
                    }
                    try {
                        i = -1;
                        noSplit = after.isEmpty();
                        if (!noSplit) {
                            try {
                                i = Integer.parseInt(after.substring(1)) - 1;
                            }
                            catch (NumberFormatException ex2) {
                                i = -1;
                            }
                            if (i < 0) {
                                String ex2 = "\u00a7cindex must be a positive integer";
                                return ex2;
                            }
                        }
                        if (!data2.left.isEmpty()) break block46;
                        ex2 = i == -1 || i == 0 ? Lang.SCOREBOARD_NONE.toString() : "";
                    }
                    catch (Exception ex3) {
                        QuestsPlugin.getPlugin().getLoggerExpanded().warning("An error occurred while parsing placeholder " + identifier + " for " + p.getName(), ex3);
                        String string = "\u00a7cinvalid placeholder";
                        return string;
                    }
                    return ex2;
                }
                Quest quest2 = data2.left.get(0);
                String desc = quest2.getDescriptionLine(quester, DescriptionSource.PLACEHOLDER);
                String format = noSplit ? this.inlineFormat : this.splitFormat;
                format = format.replace("{questName}", quest2.getName()).replace("{questDescription}", desc);
                if (noSplit) {
                    String string = format;
                    return string;
                }
                List<String> lines = ChatColorUtils.wordWrap(format, this.lineLength);
                if (i >= lines.size()) {
                    String string = "";
                    return string;
                }
                String string = lines.get(i);
                return string;
            }
            finally {
                this.playersLock.unlock();
            }
        }
        if (identifier.startsWith("advancement_")) {
            int rawIndex = identifier.indexOf("_raw");
            String sid = rawIndex == -1 ? identifier.substring(12) : identifier.substring(12, rawIndex);
            try {
                Quest qu = QuestsAPI.getAPI().getQuestsManager().getQuest(Integer.parseInt(sid));
                if (qu == null) {
                    return "\u00a7c\u00a7lError: unknown quest \u00a7o" + sid;
                }
                if (rawIndex == -1) {
                    if (qu.hasStarted(quester)) {
                        return qu.getDescriptionLine(quester, DescriptionSource.PLACEHOLDER);
                    }
                    if (qu.hasFinished(quester)) {
                        return Lang.Finished.quickFormat("times_finished", quester.getDataHolder().getQuestData(qu).getTimesFinished());
                    }
                    return Lang.Not_Started.toString();
                }
                return quester.getDataHolder().getQuestDataIfPresent(qu).map(data -> switch (data.getState()) {
                    default -> throw new IncompatibleClassChangeError();
                    case QuesterQuestData.State.IN_END -> "end";
                    case QuesterQuestData.State.IN_ENDING_STAGES -> "end_stages";
                    case QuesterQuestData.State.IN_REGULAR_STAGE -> Integer.toString(data.getStage().orElseThrow());
                    case QuesterQuestData.State.NOT_STARTED -> "-1";
                }).orElse("-1");
            }
            catch (NumberFormatException ex) {
                return "\u00a7c\u00a7lError: \u00a7o" + sid + " not a number";
            }
        }
        if (identifier.startsWith("player_quest_finished_")) {
            String sid = identifier.substring(22);
            try {
                Quest qu = QuestsAPI.getAPI().getQuestsManager().getQuest(Integer.parseInt(sid));
                if (qu == null) {
                    return "\u00a7c\u00a7lError: unknown quest \u00a7o" + sid;
                }
                return quester.getDataHolder().getQuestDataIfPresent(qu).map(data -> data.getTimesFinished()).orElse(0).toString();
            }
            catch (NumberFormatException ex) {
                return "\u00a7c\u00a7lError: \u00a7o" + sid;
            }
        }
        return null;
    }

    private void launchTask() {
        this.task = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)QuestsPlugin.getPlugin(), () -> {
            this.playersLock.lock();
            try {
                Iterator<Map.Entry<Player, PlayerPlaceholderData>> iterator = this.players.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Player, PlayerPlaceholderData> entry = iterator.next();
                    if (!entry.getKey().isOnline()) {
                        iterator.remove();
                        continue;
                    }
                    PlayerPlaceholderData data = entry.getValue();
                    if (data.left.isEmpty()) continue;
                    data.left.remove(0);
                }
            }
            finally {
                this.playersLock.unlock();
            }
        }, 0L, (long)(this.changeTime * 20));
    }

    @EventHandler
    public void onExpansionRegister(ExpansionRegisterEvent e) {
        Iterator<Map.Entry<String, Consumer<PlaceholderExpansion>>> iterator = this.waitingExpansions.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Consumer<PlaceholderExpansion>> entry = iterator.next();
            if (!entry.getKey().equalsIgnoreCase(e.getExpansion().getIdentifier())) continue;
            entry.getValue().accept(e.getExpansion());
            iterator.remove();
        }
    }

    class PlayerPlaceholderData {
        private List<Quest> left = Collections.emptyList();
        private Quester acc;

        public PlayerPlaceholderData(Quester acc) {
            this.acc = acc;
        }
    }
}

