/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.tooltips;

import fi.septicuss.tooltips.Tooltips;
import fi.septicuss.tooltips.managers.condition.Condition;
import fi.septicuss.tooltips.managers.condition.Context;
import fi.septicuss.tooltips.managers.condition.argument.Arguments;
import fi.septicuss.tooltips.utils.validation.Validity;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.npcs.dialogs.Message;
import fr.skytasul.quests.api.npcs.dialogs.MessageSender;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class TooltipsMessageSender
implements MessageSender {
    private Map<Player, DialogRunner> players = new HashMap<Player, DialogRunner>();

    public TooltipsMessageSender() {
        Tooltips.get().getConditionManager().register((Condition)new BqTooltipsCondition());
    }

    @Override
    public void displayMessage(@NotNull Player player, @NotNull DialogRunner dialog, @NotNull Message message) {
        if (this.players.containsKey(player)) {
            Bukkit.getScheduler().runTaskLater((Plugin)QuestsPlugin.getPlugin(), () -> Tooltips.get().getTooltipManager().runActions("beautyquests-ready", player), (long)(Tooltips.get().getCheckFrequency() + 1));
        } else {
            this.players.put(player, dialog);
        }
    }

    @Override
    public void stopDisplayingMessages(@NotNull Player player, @NotNull DialogRunner dialog) {
        this.players.remove(player);
    }

    private class BqTooltipsCondition
    implements Condition {
        private BqTooltipsCondition() {
        }

        public String id() {
            return "beautyquests";
        }

        public Validity valid(Arguments arg0) {
            return Validity.TRUE;
        }

        public boolean check(Player player, Arguments args) {
            return TooltipsMessageSender.this.players.containsKey(player);
        }

        public void writeContext(Player player, Arguments args, Context context) {
            DialogRunner dialog = TooltipsMessageSender.this.players.get(player);
            if (dialog == null) {
                return;
            }
            Message message = dialog.getDialog().getMessages().get(dialog.getPlayerMessage(player));
            String npcName = this.convertToMiniMessage(dialog.getDialog().getNPCName(dialog.getNpc()));
            context.put("beautyquests.npc", (Object)npcName);
            switch (message.sender) {
                case NPC: {
                    context.put("beautyquests.speaker", (Object)npcName);
                    break;
                }
                case PLAYER: {
                    context.put("beautyquests.speaker", (Object)player.getName());
                    break;
                }
            }
            String text = message.text;
            text = MessageUtils.finalFormat(text, null, PlaceholdersContext.of(player, true, null));
            text = ChatColorUtils.wordWrap(text, 75).stream().map(this::convertToMiniMessage).collect(Collectors.joining("\n"));
            context.put("beautyquests.text", (Object)text);
        }

        @NotNull
        private String convertToMiniMessage(@NotNull String legacyMessage) {
            return (String)MiniMessage.miniMessage().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(legacyMessage));
        }
    }
}

