/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.vault.permission;

import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.integrations.vault.Vault;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Permission
implements Cloneable,
HasPlaceholders {
    public final String permission;
    public final String world;
    public final boolean take;

    public Permission(String permission, boolean take, String world) {
        this.permission = permission;
        this.take = take;
        this.world = world;
    }

    public void give(Player p) {
        Vault.changePermission(p, this.permission, this.take, this.world);
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        return PlaceholderRegistry.of("permission", this.permission, "permission_removed", MessageUtils.getYesNo(this.take), "permission_world", this.world == null ? Lang.worldGlobal.toString() : this.world);
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("perm", this.permission);
        if (this.take) {
            map.put("take", this.take);
        }
        if (this.world != null) {
            map.put("world", this.world);
        }
        return map;
    }

    public static Permission deserialize(Map<String, Object> map) {
        return new Permission((String)map.get("perm"), map.containsKey("take") ? (Boolean)map.get("take") : false, (String)map.get("world"));
    }
}

