/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.vault.permission;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.WorldParser;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.integrations.vault.permission.Permission;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PermissionGUI
extends AbstractGui {
    private String perm;
    private String world = null;
    private boolean take = false;
    private Consumer<Permission> end;

    public PermissionGUI(Consumer<Permission> end, Permission existingPerm) {
        this.end = end;
        if (existingPerm == null) {
            return;
        }
        this.perm = existingPerm.permission;
        this.world = existingPerm.world;
        this.take = existingPerm.take;
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)Lang.INVENTORY_PERMISSION.toString());
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
        inventory.setItem(0, ItemUtils.item(XMaterial.COMMAND_BLOCK, Lang.perm.toString(), new String[]{this.perm == null ? Lang.NotSet.toString() : "\u00a7b" + this.perm}));
        inventory.setItem(1, ItemUtils.item(XMaterial.FILLED_MAP, Lang.world.toString(), new String[]{this.world == null ? Lang.worldGlobal.toString() : "\u00a7b" + this.world}));
        inventory.setItem(2, ItemUtils.itemSwitch(Lang.permRemove.toString(), this.take, Lang.permRemoveLore.toString()));
        ItemStack done = QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone();
        if (this.perm == null) {
            done.setType(Material.COAL);
        }
        inventory.setItem(4, done);
    }

    @Override
    public void onClick(GuiClickEvent event) {
        switch (event.getSlot()) {
            case 0: {
                Lang.CHOOSE_PERM_REWARD.send((CommandSender)event.getPlayer());
                new TextEditor<String>(event.getPlayer(), event::reopen, x -> {
                    this.getInventory().getItem(4).setType(Material.DIAMOND);
                    this.updatePerm(event.getPlayer(), (String)x);
                }, () -> {
                    this.getInventory().getItem(4).setType(Material.COAL);
                    this.updatePerm(event.getPlayer(), null);
                }).useStrippedMessage().start();
                break;
            }
            case 1: {
                Lang.CHOOSE_PERM_WORLD.send((CommandSender)event.getPlayer());
                new TextEditor<World>(event.getPlayer(), event::reopen, worldS -> this.updateWorld(event.getPlayer(), worldS.getName()), () -> this.updateWorld(event.getPlayer(), null), new WorldParser()).start();
                break;
            }
            case 2: {
                this.take = ItemUtils.toggleSwitch(event.getClicked());
                break;
            }
            case 4: {
                if (event.getClicked().getType() == Material.COAL) break;
                this.end.accept(new Permission(this.perm, this.take, this.world));
            }
        }
    }

    private void updatePerm(Player p, String perm) {
        this.perm = perm;
        ItemUtils.lore(this.getInventory().getItem(0), new String[]{perm == null ? Lang.NotSet.toString() : "\u00a7b" + perm});
        this.reopen(p);
    }

    private void updateWorld(Player p, String name) {
        this.world = name;
        ItemUtils.lore(this.getInventory().getItem(1), new String[]{this.world == null ? Lang.worldGlobal.toString() : "\u00a7b" + this.world});
        this.reopen(p);
    }

    @Override
    public CloseBehavior onClose(Player p) {
        return StandardCloseBehavior.REOPEN;
    }
}

