/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.vault.permission;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.ListGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.integrations.vault.permission.Permission;
import fr.skytasul.quests.integrations.vault.permission.PermissionGUI;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.DyeColor;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class PermissionListGUI
extends ListGUI<Permission> {
    private Consumer<List<Permission>> end;

    public PermissionListGUI(List<Permission> list, Consumer<List<Permission>> end) {
        super(Lang.INVENTORY_PERMISSION_LIST.toString(), DyeColor.PURPLE, list);
        this.end = end;
    }

    @Override
    public ItemStack getObjectItemStack(Permission object) {
        return ItemUtils.item(XMaterial.PAPER, "\u00a7e" + object.permission, this.createLoreBuilder(object).addDescription(Lang.permRemoved.format((HasPlaceholders)object)).addDescription(Lang.permWorld.format((HasPlaceholders)object)).toLoreArray());
    }

    @Override
    public void createObject(Function<Permission, ItemStack> callback) {
        new PermissionGUI(perm -> callback.apply((Permission)perm), null).open(this.player);
    }

    @Override
    public void clickObject(Permission object, ItemStack item, ClickType clickType) {
        new PermissionGUI(perm -> {
            this.updateObject(object, perm);
            this.reopen();
        }, object).open(this.player);
    }

    @Override
    public void finish(List<Permission> objects) {
        this.end.accept(objects);
    }
}

