/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.vault.permission;

import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.integrations.vault.permission.Permission;
import fr.skytasul.quests.integrations.vault.permission.PermissionListGUI;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PermissionReward
extends AbstractReward {
    public List<Permission> permissions;

    public PermissionReward() {
        this(null, new ArrayList<Permission>());
    }

    public PermissionReward(String customDescription, List<Permission> permissions) {
        super(customDescription);
        this.permissions = permissions;
    }

    @Override
    public void give(RewardGiveContext context) {
        for (Player player : context.getQuester().getOnlinePlayers()) {
            for (Permission perm : this.permissions) {
                perm.give(player);
            }
        }
    }

    @Override
    public AbstractReward clone() {
        return new PermissionReward(this.getCustomDescription(), new ArrayList<Permission>(this.permissions));
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("permissions_amount", this.permissions.size());
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescriptionAsValue(Lang.AmountPermissions.format((HasPlaceholders)this));
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        new PermissionListGUI(this.permissions, permissions -> {
            this.permissions = permissions;
            event.reopenGUI();
        }).open(event.getPlayer());
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("perms", Utils.serializeList(this.permissions, Permission::serialize));
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.permissions.addAll(Utils.deserializeList(section.getMapList("perms"), Permission::deserialize));
    }
}

