/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.worldguard;

import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.integrations.worldguard.BQWorldGuard;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RegionRequirement
extends AbstractRequirement {
    private String worldName;
    private String regionName;
    private ProtectedRegion region;
    private boolean mustBeHighest;

    public RegionRequirement() {
        this(null, null, null, null);
    }

    public RegionRequirement(String customDescription, String customReason, String worldName, String regionName) {
        super(customDescription, customReason);
        this.worldName = worldName;
        this.setRegionName(regionName);
    }

    private void setRegionName(String regionName) {
        this.regionName = regionName;
        if (this.worldName != null) {
            this.region = BQWorldGuard.getInstance().getRegion(regionName, Bukkit.getWorld((String)this.worldName));
            if (this.region == null) {
                QuestsPlugin.getPlugin().getLoggerExpanded().warning("Region " + regionName + " no longer exist in world " + this.worldName);
            }
        }
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("region_name", () -> this.regionName);
        placeholders.register("region_world", () -> this.worldName);
    }

    @Override
    protected void addLore(LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(QuestOption.formatNullableValue(this.regionName));
    }

    @Override
    public void itemClick(QuestObjectClickEvent event) {
        Player p = event.getPlayer();
        Lang.CHOOSE_REGION_REQUIRED.send((CommandSender)p);
        new TextEditor<String>(p, event::cancel, obj -> {
            this.region = BQWorldGuard.getInstance().getRegion((String)obj, p.getWorld());
            if (this.region != null) {
                this.worldName = p.getWorld().getName();
                this.regionName = this.region.getId();
                event.reopenGUI();
            } else {
                Lang.REGION_DOESNT_EXIST.send((CommandSender)p);
                event.cancel();
            }
        }).useStrippedMessage().start();
    }

    @Override
    public boolean test(Player p) {
        if (this.region == null) {
            return false;
        }
        if (!p.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        return BQWorldGuard.getInstance().isInRegion(this.region, p.getLocation(), this.mustBeHighest);
    }

    @Override
    protected String getInvalidReason() {
        return "required region " + this.regionName + " in " + this.worldName + " does not exist";
    }

    @Override
    public boolean isValid() {
        return this.region != null;
    }

    @Override
    public AbstractRequirement clone() {
        return new RegionRequirement(this.getCustomDescription(), this.getCustomReason(), this.worldName, this.regionName);
    }

    @Override
    public void save(ConfigurationSection section) {
        super.save(section);
        section.set("world", (Object)this.worldName);
        section.set("region", (Object)this.regionName);
        if (this.mustBeHighest) {
            section.set("mustBeHighest", (Object)true);
        }
    }

    @Override
    public void load(ConfigurationSection section) {
        super.load(section);
        this.worldName = section.getString("world");
        this.setRegionName(section.getString("region"));
        this.mustBeHighest = section.getBoolean("mustBeHighest", false);
    }
}

