/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.worldguard;

import com.cryptomorin.xseries.XMaterial;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.integrations.worldguard.BQWorldGuard;
import fr.skytasul.quests.integrations.worldguard.WorldGuardEntryEvent;
import fr.skytasul.quests.integrations.worldguard.WorldGuardExitEvent;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Locatable.LocatableType(types={Locatable.LocatedType.OTHER})
public class StageArea
extends AbstractStage
implements Locatable.PreciseLocatable,
Listener {
    private static final long REFRESH_CENTER = 60000L;
    private final ProtectedRegion region;
    private final boolean exit;
    private final World world;
    private Locatable.Located center = null;
    private long lastCenter = 0L;

    public StageArea(StageController controller, String regionName, String worldName, boolean exit) {
        super(controller);
        World w = Bukkit.getWorld((String)worldName);
        Validate.notNull((Object)w, (String)("No world with specified name (\"" + worldName + "\")"));
        this.world = w;
        ProtectedRegion reg = BQWorldGuard.getInstance().getRegion(regionName, w);
        Validate.notNull((Object)reg, (String)("No region with specified name (\"" + regionName + "\")"));
        this.region = reg;
        this.exit = exit;
    }

    @EventHandler
    public void onRegionEntry(WorldGuardEntryEvent e) {
        if (this.exit) {
            return;
        }
        if (this.region == null) {
            QuestsPlugin.getPlugin().getLoggerExpanded().namedWarning("No region for " + this.toString(), this, 60, new Object[0]);
            return;
        }
        if (e.getPlayer().getWorld().equals((Object)this.world) && e.getRegionsEntered().contains(this.region) && this.matchesRequirements(e.getPlayer())) {
            for (Quester quester : this.controller.getApplicableQuesters(e.getPlayer())) {
                this.testFinition(quester, e.getPlayer());
            }
        }
    }

    @EventHandler
    public void onRegionExit(WorldGuardExitEvent e) {
        if (!this.exit) {
            return;
        }
        if (this.region == null) {
            QuestsPlugin.getPlugin().getLoggerExpanded().namedWarning("No region for " + this.toString(), this, 60, new Object[0]);
            return;
        }
        if (e.getPlayer().getWorld().equals((Object)this.world) && e.getRegionsExited().contains(this.region) && this.matchesRequirements(e.getPlayer())) {
            for (Quester quester : this.controller.getApplicableQuesters(e.getPlayer())) {
                this.testFinition(quester, e.getPlayer());
            }
        }
    }

    @Override
    public void started(@NotNull Quester quester) {
        super.started(quester);
        this.testFinition(quester, null);
    }

    private void testFinition(@NotNull Quester quester, @Nullable Player realPlayer) {
        for (Player questerPlayer : quester.getOnlinePlayers()) {
            if (realPlayer != null && questerPlayer.equals((Object)realPlayer) || BQWorldGuard.getInstance().isInRegion(this.region, questerPlayer.getLocation(), false) != this.exit) continue;
            return;
        }
        this.finishStage(quester);
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("region_id", this.region.getId());
        placeholders.register("region_world", this.world.getName());
    }

    @Override
    @NotNull
    public String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext context) {
        return Lang.SCOREBOARD_REG.toString();
    }

    @Override
    public Locatable.Located getLocated() {
        if (this.region instanceof GlobalProtectedRegion) {
            return null;
        }
        if (System.currentTimeMillis() - this.lastCenter > 60000L) {
            Location centerLoc = BukkitAdapter.adapt((World)this.world, (BlockVector3)this.region.getMaximumPoint().subtract(this.region.getMinimumPoint()).divide(2).add(this.region.getMinimumPoint())).add(0.5, 0.5, 0.5);
            this.center = Locatable.Located.create(centerLoc);
            this.lastCenter = System.currentTimeMillis();
        }
        return this.center;
    }

    public ProtectedRegion getRegion() {
        return this.region;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public void serialize(ConfigurationSection section) {
        section.set("region", (Object)this.region.getId());
        section.set("world", (Object)this.world.getName());
        section.set("exit", (Object)this.exit);
    }

    public static StageArea deserialize(ConfigurationSection section, StageController controller) {
        return new StageArea(controller, section.getString("region"), section.getString("world"), section.getBoolean("exit", false));
    }

    public static class Creator
    extends StageCreation<StageArea> {
        private boolean exit = false;
        private String regionName;
        private String worldName;

        public Creator(@NotNull StageCreationContext<StageArea> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(7, ItemUtils.item(XMaterial.PAPER, Lang.stageRegion.toString(), new String[0]), event -> this.launchRegionEditor(event.getPlayer(), false));
            line.setItem(6, ItemUtils.itemSwitch(Lang.stageRegionExit.toString(), this.exit, new String[0]), event -> this.setExit(!this.exit));
        }

        public void setRegion(String regionName, String worldName) {
            this.regionName = regionName;
            this.worldName = worldName;
            this.getLine().refreshItemLore(7, QuestOption.formatNullableValue(regionName + " (" + worldName + ")"));
        }

        public void setExit(boolean exit) {
            if (this.exit != exit) {
                this.exit = exit;
                this.getLine().refreshItem(6, item -> ItemUtils.setSwitch(item, exit));
            }
        }

        private void launchRegionEditor(Player p, boolean first) {
            MessageUtils.sendMessage((CommandSender)p, Lang.REGION_NAME.toString() + (String)(first ? "" : "\n" + Lang.TYPE_CANCEL.toString()), (MessageType)MessageType.DefaultMessageType.PREFIXED);
            new TextEditor<String>(p, () -> {
                if (first) {
                    this.context.remove();
                }
                this.context.reopenGui();
            }, obj -> {
                if (BQWorldGuard.getInstance().regionExists((String)obj, p.getWorld())) {
                    this.setRegion((String)obj, p.getWorld().getName());
                } else {
                    Lang.REGION_DOESNT_EXIST.send((CommandSender)p);
                    if (first) {
                        this.context.remove();
                    }
                }
                this.context.reopenGui();
            }).useStrippedMessage().start();
        }

        @Override
        public void start(Player p) {
            super.start(p);
            this.launchRegionEditor(p, true);
        }

        @Override
        public void edit(StageArea stage) {
            super.edit(stage);
            this.setRegion(stage.getRegion().getId(), stage.world.getName());
            this.setExit(stage.exit);
        }

        @Override
        public StageArea finishStage(StageController controller) {
            return new StageArea(controller, this.regionName, this.worldName, this.exit);
        }
    }
}

