/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.integrations.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.BukkitPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.Handler;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.integrations.worldguard.WorldGuardEntryEvent;
import fr.skytasul.quests.integrations.worldguard.WorldGuardExitEvent;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class WorldGuardEntryHandler
extends Handler {
    public static final BQFactory FACTORY = new BQFactory();

    public WorldGuardEntryHandler(Session session) {
        super(session);
    }

    public void initialize(LocalPlayer player, Location current, ApplicableRegionSet set) {
        ProtectedRegion global;
        super.initialize(player, current, set);
        HashSet<ProtectedRegion> regions = set.getRegions();
        if (current.getExtent() instanceof World && (global = WorldGuard.getInstance().getPlatform().getRegionContainer().get((World)current.getExtent()).getRegion("__global__")) != null) {
            regions = new HashSet<ProtectedRegion>(regions);
            regions.add(global);
        }
        HashSet<ProtectedRegion> finalRegions = regions;
        Bukkit.getScheduler().runTaskLater((Plugin)QuestsPlugin.getPlugin(), () -> Bukkit.getPluginManager().callEvent((Event)new WorldGuardEntryEvent(BukkitAdapter.adapt((Player)player), finalRegions)), 1L);
    }

    public boolean onCrossBoundary(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, Set<ProtectedRegion> entered, Set<ProtectedRegion> exited, MoveType moveType) {
        org.bukkit.entity.Player bukkitPlayer = BukkitAdapter.adapt((Player)player);
        if (!QuestsPlugin.getPlugin().getNpcManager().isNPC((Entity)bukkitPlayer)) {
            if (!from.getExtent().equals((Object)to.getExtent()) && from.getExtent() instanceof World && to.getExtent() instanceof World) {
                ProtectedRegion fromGlobal = WorldGuard.getInstance().getPlatform().getRegionContainer().get((World)from.getExtent()).getRegion("__global__");
                ProtectedRegion toGlobal = WorldGuard.getInstance().getPlatform().getRegionContainer().get((World)to.getExtent()).getRegion("__global__");
                if (toGlobal != null) {
                    entered = new HashSet<ProtectedRegion>(entered);
                    entered.add(toGlobal);
                }
                if (fromGlobal != null) {
                    exited = new HashSet<ProtectedRegion>(exited);
                    exited.add(fromGlobal);
                }
            }
            if (!entered.isEmpty() || !exited.isEmpty()) {
                Set<ProtectedRegion> enteredFinal = entered;
                Set<ProtectedRegion> exitedFinal = exited;
                Bukkit.getScheduler().runTask((Plugin)QuestsPlugin.getPlugin(), () -> {
                    if (!enteredFinal.isEmpty()) {
                        Bukkit.getPluginManager().callEvent((Event)new WorldGuardEntryEvent(bukkitPlayer, enteredFinal));
                    }
                    if (!exitedFinal.isEmpty()) {
                        Bukkit.getPluginManager().callEvent((Event)new WorldGuardExitEvent(bukkitPlayer, exitedFinal));
                    }
                });
            }
        }
        return true;
    }

    public static final class BQFactory
    extends Handler.Factory<WorldGuardEntryHandler> {
        public WorldGuardEntryHandler create(Session session) {
            return new WorldGuardEntryHandler(session);
        }

        public boolean register(SessionManager sessionManager) {
            return sessionManager.registerHandler((Handler.Factory)this, null);
        }

        public void registerSessions(SessionManager sessionManager) {
            for (org.bukkit.entity.Player player : Bukkit.getServer().getOnlinePlayers()) {
                BukkitPlayer bukkitPlayer = new BukkitPlayer(WorldGuardPlugin.inst(), player);
                Session session = sessionManager.getIfPresent((LocalPlayer)bukkitPlayer);
                if (session == null) continue;
                session.register((Handler)this.create(session));
                session.resetState((LocalPlayer)bukkitPlayer);
            }
        }

        public void unregister(SessionManager sessionManager) {
            sessionManager.unregisterHandler((Handler.Factory)this);
        }
    }
}

