/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.mobs;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.mobs.MobFactory;
import fr.skytasul.quests.api.utils.MinecraftNames;
import fr.skytasul.quests.api.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

public class BukkitEntityFactory
implements MobFactory<EntityType>,
Listener {
    private ItemStack item = ItemUtils.item(XMaterial.BLAZE_SPAWN_EGG, Lang.bukkitMob.toString(), new String[0]);

    @Override
    public String getID() {
        return "bukkitEntity";
    }

    @Override
    public ItemStack getFactoryItem() {
        return this.item;
    }

    @Override
    public void itemClick(Player p, Consumer<EntityType> run) {
        QuestsPlugin.getPlugin().getGuiManager().getFactory().createEntityTypeSelection(run, x -> x != null).open(p);
    }

    @Override
    public boolean bukkitMobApplies(EntityType first, Entity entity) {
        return entity.getType() == first;
    }

    @Override
    public EntityType fromValue(String value) {
        return EntityType.valueOf((String)value);
    }

    @Override
    public String getValue(EntityType data) {
        return data.name();
    }

    @Override
    public String getName(EntityType data) {
        return MinecraftNames.getEntityName(data);
    }

    @Override
    public EntityType getEntityType(EntityType data) {
        return data;
    }

    @Override
    public List<String> getDescriptiveLore(EntityType data) {
        return Arrays.asList(Lang.EntityType.quickFormat("entity_type", MinecraftNames.getEntityName(data)));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityKilled(EntityDeathEvent e) {
        Entity killer = Utils.getEntityKiller(e.getEntity());
        if (killer == null) {
            return;
        }
        this.callEvent((Event)e, e.getEntity().getType(), (Entity)e.getEntity(), killer);
    }
}

