/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.mobs;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.mobs.LeveledMobFactory;
import fr.skytasul.quests.api.mobs.MobFactory;
import fr.skytasul.quests.api.utils.Utils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mob<D>
implements Cloneable {
    private static final NumberFormat LEVEL_FORMAT = new DecimalFormat();
    protected final MobFactory<D> factory;
    protected final D data;
    protected String customName;
    protected Double minLevel;
    private String formattedName;

    public Mob(@NotNull MobFactory<D> factory, @NotNull D data) {
        Validate.notNull(factory, (String)"Mob factory cannot be null");
        Validate.notNull(data, (String)"Mob data cannot be null");
        this.factory = factory;
        this.data = data;
    }

    @NotNull
    public MobFactory<D> getFactory() {
        return this.factory;
    }

    @NotNull
    public D getData() {
        return this.data;
    }

    @NotNull
    public String getName() {
        if (this.formattedName == null) {
            if (this.customName != null) {
                this.formattedName = this.customName;
            } else {
                this.formattedName = this.factory.getName(this.data);
                if (this.minLevel != null) {
                    this.formattedName = this.formattedName + " lvl " + LEVEL_FORMAT.format(this.minLevel);
                }
            }
        }
        return this.formattedName;
    }

    public @NotNull List<@Nullable String> getDescriptiveLore() {
        return this.factory.getDescriptiveLore(this.data);
    }

    public void setCustomName(@Nullable String customName) {
        this.customName = customName;
        this.formattedName = null;
    }

    @Nullable
    public Double getMinLevel() {
        return this.minLevel;
    }

    public void setMinLevel(@Nullable Double minLevel) {
        this.minLevel = minLevel;
        this.formattedName = null;
    }

    @NotNull
    public XMaterial getMobItem() {
        try {
            return Utils.mobItem(this.factory.getEntityType(this.data));
        }
        catch (Exception ex) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Unknow entity type for mob " + this.factory.getName(this.data), ex);
            return XMaterial.SPONGE;
        }
    }

    public boolean applies(@Nullable Object data) {
        return this.factory.mobApplies(this.data, data);
    }

    public boolean appliesEntity(@NotNull Entity entity) {
        return this.factory.bukkitMobApplies(this.data, entity);
    }

    public double getLevel(@NotNull Entity entity) {
        if (!(this.factory instanceof LeveledMobFactory)) {
            throw new UnsupportedOperationException("Cannot get the level of a mob from an unleveled mob factory: " + this.factory.getID());
        }
        return ((LeveledMobFactory)this.factory).getMobLevel(this.data, entity);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 27 + this.factory.hashCode();
        hash = hash * 27 + this.data.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Mob) {
            Mob mob = (Mob)obj;
            return this.factory.equals(mob.factory) && this.data.equals(mob.data);
        }
        return false;
    }

    public Mob<D> clone() {
        try {
            return (Mob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("factoryName", this.factory.getID());
        map.put("value", this.factory.getValue(this.data));
        if (this.customName != null) {
            map.put("name", this.customName);
        }
        if (this.minLevel != null) {
            map.put("minLevel", this.minLevel);
        }
        return map;
    }

    public static Mob<?> deserialize(Map<String, Object> map) {
        String factoryName = (String)map.get("factoryName");
        String value = (String)map.get("value");
        MobFactory<?> factory = MobFactory.getMobFactory(factoryName);
        if (factory == null) {
            throw new IllegalArgumentException("The factory " + factoryName + " is not installed in BeautyQuests.");
        }
        Object object = factory.fromValue(value);
        if (object == null) {
            throw new IllegalArgumentException("Can't find the mob " + value + " for factory " + factoryName);
        }
        Mob mob = new Mob(factory, object);
        if (map.containsKey("name")) {
            mob.setCustomName((String)map.get("name"));
        }
        if (map.containsKey("minLevel")) {
            mob.setMinLevel((Double)map.get("minLevel"));
        }
        return mob;
    }
}

