/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.npcs;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.QuestsConfigurationImplementation;
import fr.skytasul.quests.api.AbstractHolograms;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqInternalNpc;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.npcs.BqNpcManagerImplementation;
import fr.skytasul.quests.options.OptionHologramLaunch;
import fr.skytasul.quests.options.OptionHologramLaunchNo;
import fr.skytasul.quests.options.OptionHologramText;
import fr.skytasul.quests.options.OptionStarterNPC;
import fr.skytasul.quests.structure.pools.QuestPoolImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BqNpcImplementation
implements Locatable.Located.LocatedEntity,
BqNpc {
    private Map<Quest, List<Player>> quests = new TreeMap<Quest, List<Player>>();
    private Set<QuestPool> pools = new TreeSet<QuestPool>();
    private List<Map.Entry<Player, Object>> hiddenTickets = new ArrayList<Map.Entry<Player, Object>>();
    private Map<Object, Predicate<Player>> startable = new HashMap<Object, Predicate<Player>>();
    private BukkitTask launcheableTask;
    private boolean debug = false;
    private BukkitTask hologramsTask;
    private boolean hologramsRemoved = true;
    private Hologram hologramText = new Hologram(false, QuestsAPI.getAPI().hasHologramsManager() && !QuestsConfigurationImplementation.getConfiguration().isTextHologramDisabled(), Lang.HologramText.toString());
    private Hologram hologramLaunch = new Hologram(false, QuestsAPI.getAPI().hasHologramsManager() && QuestsAPI.getAPI().getHologramsManager().supportItems(), QuestsConfigurationImplementation.getConfiguration().getHoloLaunchItem());
    private Hologram hologramLaunchNo = new Hologram(false, QuestsAPI.getAPI().hasHologramsManager() && QuestsAPI.getAPI().getHologramsManager().supportItems() && QuestsAPI.getAPI().getHologramsManager().supportPerPlayerVisibility(), QuestsConfigurationImplementation.getConfiguration().getHoloLaunchNoItem());
    private Hologram hologramPool = new Hologram(false, QuestsAPI.getAPI().hasHologramsManager() && QuestsAPI.getAPI().getHologramsManager().supportPerPlayerVisibility(), Lang.PoolHologramText.toString()){

        @Override
        public double getYAdd() {
            return BqNpcImplementation.this.hologramText.canAppear && BqNpcImplementation.this.hologramText.visible ? 0.55 : 0.0;
        }
    };
    private final boolean holograms;
    @NotNull
    private final BqNpcManagerImplementation.WrappedInternalNpc wrappedNpc;
    @Nullable
    private PlaceholderRegistry placeholders;

    public BqNpcImplementation(@NotNull BqNpcManagerImplementation.WrappedInternalNpc wrappedNpc) {
        this.wrappedNpc = wrappedNpc;
        this.holograms = this.hologramText.enabled || this.hologramLaunch.enabled || this.hologramLaunchNo.enabled || this.hologramPool.enabled;
    }

    @NotNull
    public BqNpcManagerImplementation.WrappedInternalNpc getWrappedNpc() {
        return this.wrappedNpc;
    }

    @Override
    public String getId() {
        return this.wrappedNpc.getId();
    }

    @Override
    public BqInternalNpc getNpc() {
        return this.wrappedNpc.getNpc();
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.getNpc().getEntity();
    }

    @Override
    @NotNull
    public Location getLocation() {
        return Objects.requireNonNull(this.getNpc().getLocation());
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry().register("npc_name", this.getNpc().getName()).register("npc_id", this.getId());
        }
        return this.placeholders;
    }

    private void startLauncheableTasks() {
        this.launcheableTask = new BukkitRunnable(){
            private int timer = 0;

            public void run() {
                if (!BqNpcImplementation.this.getNpc().isSpawned()) {
                    return;
                }
                if (!(BqNpcImplementation.this.getEntity() instanceof LivingEntity)) {
                    return;
                }
                LivingEntity en = (LivingEntity)BqNpcImplementation.this.getEntity();
                if (this.timer-- == 0) {
                    this.timer = QuestsConfiguration.getConfig().getQuestsConfig().requirementUpdateTime();
                    return;
                }
                BqNpcImplementation.this.quests.values().forEach(List::clear);
                HashSet<Player> playersInRadius = new HashSet<Player>();
                Location lc = en.getLocation();
                block0: for (Player p : lc.getWorld().getPlayers()) {
                    PlayerQuester acc = PlayerManager.getPlayerAccount(p);
                    if (acc == null || lc.distanceSquared(p.getLocation()) > Math.pow(QuestsConfiguration.getConfig().getQuestsConfig().startParticleDistance(), 2.0)) continue;
                    playersInRadius.add(p);
                    for (Map.Entry entry2 : BqNpcImplementation.this.quests.entrySet()) {
                        if (!((Quest)entry2.getKey()).canStart(p, false)) continue;
                        ((List)entry2.getValue()).add(p);
                        continue block0;
                    }
                }
                if (QuestsConfigurationImplementation.getConfiguration().showStartParticles()) {
                    BqNpcImplementation.this.quests.forEach((quest, players) -> QuestsConfigurationImplementation.getConfiguration().getParticleStart().send((Entity)en, (List<Player>)players));
                }
                if (BqNpcImplementation.this.hologramPool.canAppear) {
                    for (Player p : playersInRadius) {
                        boolean visible = false;
                        for (QuestPool questPool : BqNpcImplementation.this.pools) {
                            if (!questPool.canGive(p).result()) continue;
                            visible = true;
                            break;
                        }
                        BqNpcImplementation.this.hologramPool.setVisible(p, visible);
                    }
                }
                if (BqNpcImplementation.this.hologramLaunch.canAppear || BqNpcImplementation.this.hologramLaunchNo.canAppear) {
                    ArrayList<Player> launcheable = new ArrayList<Player>();
                    ArrayList<Player> unlauncheable = new ArrayList<Player>();
                    Iterator iterator = playersInRadius.iterator();
                    while (iterator.hasNext()) {
                        Player player = (Player)iterator.next();
                        if (BqNpcImplementation.this.hiddenTickets.stream().anyMatch(entry -> entry.getKey() == player)) {
                            iterator.remove();
                            continue;
                        }
                        PlayerQuester playerQuester = PlayerManager.getPlayerAccount(player);
                        boolean launchYes = false;
                        boolean launchNo = false;
                        for (Map.Entry<Quest, List<Player>> qu : BqNpcImplementation.this.quests.entrySet()) {
                            if (qu.getKey().hasStarted(playerQuester)) continue;
                            boolean pLauncheable = qu.getValue().contains(player);
                            if (BqNpcImplementation.this.hologramLaunch.enabled && pLauncheable) {
                                launchYes = true;
                                break;
                            }
                            if (!BqNpcImplementation.this.hologramLaunchNo.enabled || pLauncheable) continue;
                            launchNo = true;
                        }
                        if (launchYes) {
                            launcheable.add(player);
                            iterator.remove();
                            continue;
                        }
                        if (!launchNo) continue;
                        unlauncheable.add(player);
                        iterator.remove();
                    }
                    BqNpcImplementation.this.hologramLaunch.setVisible(launcheable);
                    BqNpcImplementation.this.hologramLaunchNo.setVisible(unlauncheable);
                }
            }
        }.runTaskTimer((Plugin)BeautyQuests.getInstance(), 20L, 20L);
    }

    private void stopLauncheableTask() {
        if (this.launcheableTask != null) {
            this.launcheableTask.cancel();
            this.launcheableTask = null;
        }
    }

    private void startHologramsTask() {
        this.hologramsTask = new BukkitRunnable(){

            public void run() {
                LivingEntity en = null;
                if (BqNpcImplementation.this.getNpc().isSpawned() && BqNpcImplementation.this.getEntity() instanceof LivingEntity) {
                    en = (LivingEntity)BqNpcImplementation.this.getEntity();
                }
                if (en == null) {
                    if (!BqNpcImplementation.this.hologramsRemoved) {
                        BqNpcImplementation.this.removeHolograms(false);
                    }
                    return;
                }
                BqNpcImplementation.this.hologramsRemoved = false;
                if (BqNpcImplementation.this.hologramText.canAppear && BqNpcImplementation.this.hologramText.visible) {
                    BqNpcImplementation.this.hologramText.refresh(en);
                }
                if (BqNpcImplementation.this.hologramLaunch.canAppear) {
                    BqNpcImplementation.this.hologramLaunch.refresh(en);
                }
                if (BqNpcImplementation.this.hologramLaunchNo.canAppear) {
                    BqNpcImplementation.this.hologramLaunchNo.refresh(en);
                }
                if (BqNpcImplementation.this.hologramPool.canAppear) {
                    BqNpcImplementation.this.hologramPool.refresh(en);
                }
            }
        }.runTaskTimer((Plugin)BeautyQuests.getInstance(), 20L, 1L);
    }

    @Override
    public Set<Quest> getQuests() {
        return this.quests.keySet();
    }

    public Hologram getHologramText() {
        return this.hologramText;
    }

    public Hologram getHologramLaunch() {
        return this.hologramLaunch;
    }

    public Hologram getHologramLaunchNo() {
        return this.hologramLaunchNo;
    }

    public void addQuest(Quest quest) {
        if (this.quests.containsKey(quest)) {
            return;
        }
        this.quests.put(quest, new ArrayList());
        if (this.hologramText.enabled && quest.hasOption(OptionHologramText.class)) {
            this.hologramText.setText((String)quest.getOption(OptionHologramText.class).getValue());
        }
        if (this.hologramLaunch.enabled && quest.hasOption(OptionHologramLaunch.class)) {
            this.hologramLaunch.setItem((ItemStack)quest.getOption(OptionHologramLaunch.class).getValue());
        }
        if (this.hologramLaunchNo.enabled && quest.hasOption(OptionHologramLaunchNo.class)) {
            this.hologramLaunchNo.setItem((ItemStack)quest.getOption(OptionHologramLaunchNo.class).getValue());
        }
        this.hologramText.visible = true;
        this.addStartablePredicate(p -> quest.canStart((Player)p, false), quest);
        this.updatedObjects();
    }

    public boolean removeQuest(Quest quest) {
        boolean b = this.quests.remove(quest) == null;
        this.removeStartablePredicate(quest);
        this.updatedObjects();
        if (this.quests.isEmpty()) {
            this.hologramText.visible = false;
            this.hologramText.delete();
        }
        return b;
    }

    @Override
    public boolean hasQuestStarted(Player p) {
        PlayerQuester acc = PlayerManager.getPlayerAccount(p);
        return this.quests.keySet().stream().anyMatch(quest -> quest.hasStarted(acc));
    }

    @Override
    public Set<QuestPool> getPools() {
        return this.pools;
    }

    public void addPool(QuestPool pool) {
        if (!this.pools.add(pool)) {
            return;
        }
        if (this.hologramPool.enabled && pool.getHologram() != null) {
            this.hologramPool.setText(pool.getHologram());
        }
        this.addStartablePredicate(p -> pool.canGive((Player)p).result(), pool);
        this.updatedObjects();
    }

    public boolean removePool(QuestPool pool) {
        boolean b = this.pools.remove(pool);
        this.removeStartablePredicate(pool);
        this.updatedObjects();
        if (this.pools.isEmpty()) {
            this.hologramPool.delete();
        }
        return b;
    }

    @Override
    public void addStartablePredicate(Predicate<Player> predicate, Object holder) {
        this.startable.put(holder, predicate);
    }

    @Override
    public void removeStartablePredicate(Object holder) {
        this.startable.remove(holder);
    }

    @Override
    public void hideForPlayer(Player p, Object holder) {
        this.hiddenTickets.add(new AbstractMap.SimpleEntry<Player, Object>(p, holder));
    }

    @Override
    public void removeHiddenForPlayer(Player p, Object holder) {
        Iterator<Map.Entry<Player, Object>> iterator = this.hiddenTickets.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Player, Object> entry = iterator.next();
            if (entry.getKey() != p || entry.getValue() != holder) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public boolean canGiveSomething(Player p) {
        return this.startable.values().stream().anyMatch(predicate -> predicate.test(p));
    }

    private void removeHolograms(boolean cancelRefresh) {
        this.hologramText.delete();
        this.hologramLaunch.delete();
        this.hologramLaunchNo.delete();
        this.hologramPool.delete();
        this.hologramsRemoved = true;
        if (cancelRefresh && this.hologramsTask != null) {
            this.hologramsTask.cancel();
            this.hologramsTask = null;
        }
    }

    private boolean isEmpty() {
        return this.quests.isEmpty() && this.pools.isEmpty();
    }

    private void updatedObjects() {
        if (this.isEmpty()) {
            this.stopLauncheableTask();
            this.removeHolograms(true);
        } else {
            if (this.launcheableTask == null) {
                this.startLauncheableTasks();
            }
            if (this.holograms && this.hologramsTask == null) {
                this.startHologramsTask();
            }
        }
    }

    public void unload() {
        this.removeHolograms(true);
        this.stopLauncheableTask();
    }

    public void delete(String cause) {
        QuestsPlugin.getPlugin().getLoggerExpanded().debug("Removing NPC Starter " + this.getId());
        for (Quest qu : this.quests.keySet()) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Starter NPC #" + this.getId() + " has been removed from quest " + qu.getId() + ". Reason: " + cause);
            qu.removeOption(OptionStarterNPC.class);
        }
        this.quests = null;
        for (QuestPool pool : this.pools) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("NPC " + this.getId() + " has been removed from pool " + pool.getId() + ". Reason: " + cause);
            ((QuestPoolImplementation)pool).unloadStarter();
        }
        this.unload();
    }

    public void toggleDebug() {
        this.debug = !this.debug;
    }

    public String toString() {
        Object hologramsInfo;
        String npcInfo = "NPC " + this.getId() + ", " + this.quests.size() + " quests, " + this.pools.size() + " pools";
        if (!this.holograms) {
            hologramsInfo = "no holograms";
        } else if (this.hologramsRemoved) {
            hologramsInfo = "holograms removed";
        } else {
            hologramsInfo = "holograms:";
            hologramsInfo = (String)hologramsInfo + "\n- text=" + this.hologramText.toString();
            hologramsInfo = (String)hologramsInfo + "\n- launch=" + this.hologramLaunch.toString();
            hologramsInfo = (String)hologramsInfo + "\n- launchNo=" + this.hologramLaunchNo.toString();
            hologramsInfo = (String)hologramsInfo + "\n- pool=" + this.hologramPool.toString();
        }
        return npcInfo + " " + (String)hologramsInfo;
    }

    public class Hologram {
        final boolean enabled;
        boolean visible;
        boolean canAppear;
        AbstractHolograms.BQHologram hologram;
        String text;
        ItemStack item;

        public Hologram(boolean visible, boolean enabled, String text) {
            this.visible = visible;
            this.enabled = enabled;
            this.setText(text);
        }

        public Hologram(boolean visible, boolean enabled, ItemStack item) {
            this.visible = visible;
            this.enabled = enabled;
            this.setItem(item);
        }

        public void refresh(LivingEntity en) {
            Location lc = QuestUtils.upLocationForEntity(en, this.getYAdd());
            if (BqNpcImplementation.this.debug) {
                System.out.println("refreshing " + this.toString() + " (hologram null: " + (this.hologram == null) + ")");
            }
            if (this.hologram == null) {
                this.create(lc);
            } else {
                this.hologram.teleport(lc);
            }
        }

        public double getYAdd() {
            return this.item == null ? 0.0 : 1.0;
        }

        public void setVisible(List<Player> players) {
            if (this.hologram != null) {
                this.hologram.setPlayersVisible(players);
            }
        }

        public void setVisible(Player p, boolean visibility) {
            if (this.hologram != null) {
                this.hologram.setPlayerVisibility(p, visibility);
            }
        }

        public void setText(String text) {
            if (Objects.equals(text, this.text)) {
                return;
            }
            this.text = text;
            this.canAppear = this.enabled && !StringUtils.isEmpty((String)text) && !"none".equals(text);
            this.delete();
        }

        public void setItem(ItemStack item) {
            if (Objects.equals(item, this.item)) {
                return;
            }
            this.item = item;
            boolean bl = this.canAppear = this.enabled && item != null;
            if (this.canAppear && QuestsConfigurationImplementation.getConfiguration().isCustomHologramNameShown() && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
                this.text = item.getItemMeta().getDisplayName();
            }
            this.delete();
        }

        public void create(Location lc) {
            if (this.hologram != null) {
                return;
            }
            this.hologram = QuestsAPI.getAPI().getHologramsManager().createHologram(lc, this.visible);
            if (this.text != null) {
                this.hologram.appendTextLine(this.text);
            }
            if (this.item != null) {
                this.hologram.appendItem(this.item);
            }
        }

        public void delete() {
            if (BqNpcImplementation.this.debug) {
                System.out.println("deleting " + this.toString());
            }
            if (this.hologram == null) {
                return;
            }
            this.hologram.delete();
            this.hologram = null;
        }

        public String toString() {
            if (!this.enabled) {
                return "disabled";
            }
            if (!this.canAppear) {
                return "cannot appear";
            }
            return (this.visible ? "visible" : "invisible") + " by default, " + (String)(this.item == null ? "" : this.item.getType().name() + ", ") + (String)(this.text == null ? "no text" : "text=" + this.text) + ", " + (this.hologram == null ? " not spawned" : "spawned");
        }
    }
}

