/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.npcs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fr.skytasul.quests.DefaultQuestFeatures;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.npcs.BqInternalNpc;
import fr.skytasul.quests.api.npcs.BqInternalNpcFactory;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.npcs.BqNpcManager;
import fr.skytasul.quests.api.npcs.NpcClickType;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.npcs.BQNPCClickEvent;
import fr.skytasul.quests.npcs.BqNpcImplementation;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BqNpcManagerImplementation
implements BqNpcManager {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.NpcManager");
    private static final String SEPARATOR = "#";
    private static final Pattern FACTORY_KEY_PATTERN = Pattern.compile("[a-zA-Z0-9_-]*");
    private final BiMap<String, BqInternalNpcFactory> internalFactories = HashBiMap.create();
    private final Map<String, BqNpcImplementation> npcs = new HashMap<String, BqNpcImplementation>();
    private BqInternalNpcFactory last = null;

    @NotNull
    public String getFactoryKey(@NotNull BqInternalNpcFactory internalFactory) {
        return (String)this.internalFactories.inverse().get((Object)internalFactory);
    }

    private String getNpcId(BqInternalNpcFactory factory, String internalId) {
        return this.getFactoryKey(factory) + SEPARATOR + internalId;
    }

    private BqInternalNpcFactory getMigrationFactory() {
        return this.last;
    }

    public Collection<BqInternalNpcFactory> getInternalFactories() {
        return this.internalFactories.values();
    }

    public long getTimeToWaitForNPCs() {
        return this.internalFactories.values().stream().mapToInt(BqInternalNpcFactory::getTimeToWaitForNPCs).max().orElse(0);
    }

    @Override
    public boolean isEnabled() {
        return !this.internalFactories.isEmpty();
    }

    @Override
    public void addInternalFactory(@NotNull String key, @NotNull BqInternalNpcFactory internalFactory) {
        if (this.internalFactories.containsKey((Object)key)) {
            throw new IllegalArgumentException("Npc factory " + key + " is already registered");
        }
        if (!FACTORY_KEY_PATTERN.matcher(key).matches()) {
            throw new IllegalArgumentException("Invalid factory key " + key);
        }
        LOGGER.debug("Adding {0} as an npc factory", key);
        this.internalFactories.put((Object)key, (Object)internalFactory);
        this.last = internalFactory;
        QuestUtils.autoRegister(internalFactory);
        DefaultQuestFeatures.registerNpcFeatures();
    }

    @Override
    @NotNull
    public Collection<String> getAvailableIds() {
        return this.internalFactories.values().stream().flatMap(factory -> factory.getIDs().stream().map(id -> this.getNpcId((BqInternalNpcFactory)factory, (String)id))).collect(Collectors.toList());
    }

    @Override
    public boolean isNPC(@NotNull Entity entity) {
        if (!entity.getMetadata("NPC").isEmpty()) {
            return true;
        }
        return this.internalFactories.values().stream().anyMatch(factory -> factory.isNPC(entity));
    }

    @Override
    @NotNull
    public BqNpc createNPC(@NotNull BqInternalNpcFactory.BqInternalNpcFactoryCreatable internalFactory, @NotNull Location location, @NotNull EntityType type, @NotNull String name, @Nullable String skin) {
        BqInternalNpc internal = internalFactory.create(location, type, name, skin);
        BqNpcImplementation npc = new BqNpcImplementation(new WrappedInternalNpc(internalFactory, internal));
        this.npcs.put(npc.getId(), npc);
        return npc;
    }

    @Override
    @Nullable
    public BqNpcImplementation getById(String id) {
        String internalId;
        BqInternalNpcFactory factory;
        int separatorIndex = id.indexOf(SEPARATOR);
        if (separatorIndex == -1) {
            LOGGER.debug("Loading NPC with id {0} from a previous version of the plugin.", id);
            factory = this.getMigrationFactory();
            internalId = id;
        } else {
            String factoryKey = id.substring(0, separatorIndex);
            factory = (BqInternalNpcFactory)this.internalFactories.get((Object)factoryKey);
            internalId = id.substring(separatorIndex + SEPARATOR.length());
        }
        if (factory == null) {
            throw new IllegalArgumentException("Cannot find factory for NPC " + id + ". Is your NPC plugin installed?");
        }
        return this.getByFactoryAndId(factory, internalId).orElse(null);
    }

    @NotNull
    public Optional<BqNpcImplementation> getByFactoryAndId(@NotNull BqInternalNpcFactory factory, String internalId) {
        String npcId = this.getNpcId(factory, internalId);
        if (this.npcs.containsKey(npcId)) {
            return Optional.of(this.npcs.get(npcId));
        }
        BqInternalNpc npc = factory.fetchNPC(internalId);
        if (npc == null) {
            return Optional.empty();
        }
        BqNpcImplementation npcImplem = new BqNpcImplementation(new WrappedInternalNpc(factory, npc));
        this.npcs.put(npcId, npcImplem);
        return Optional.of(npcImplem);
    }

    @Override
    public void npcRemoved(BqInternalNpcFactory npcFactory, String internalId) {
        String npcId = this.getNpcId(npcFactory, internalId);
        BqNpcImplementation npc = this.npcs.get(npcId);
        if (npc == null) {
            return;
        }
        npc.delete("NPC " + npcId + " removed");
        this.npcs.remove(npcId);
    }

    @Override
    public void npcClicked(BqInternalNpcFactory npcFactory, @Nullable Cancellable event, String internalId, @NotNull Player p, @NotNull NpcClickType click) {
        if (event != null && event.isCancelled()) {
            return;
        }
        BQNPCClickEvent newEvent = new BQNPCClickEvent(this.getByFactoryAndId(npcFactory, internalId).get(), p, click);
        if (event == null || QuestsConfiguration.getConfig().getQuestsConfig().dontCancelNpcClick()) {
            QuestUtils.runOrSync(() -> Bukkit.getPluginManager().callEvent((Event)newEvent));
        } else {
            QuestUtils.tunnelEventCancelling(event, (Event)newEvent);
        }
    }

    @Override
    public void reload(BqInternalNpcFactory npcFactory) {
        this.npcs.forEach((id, npc) -> {
            if (npc.getWrappedNpc().factory != npcFactory) {
                return;
            }
            BqInternalNpc newInternal = npcFactory.fetchNPC(npc.getWrappedNpc().internalId);
            if (newInternal == null) {
                LOGGER.warning("Unable to find NPC with ID {0} after a NPCs manager reload.", id);
            } else {
                npc.getWrappedNpc().npc = newInternal;
            }
        });
    }

    public void unload() {
        this.npcs.values().forEach(BqNpcImplementation::unload);
        this.npcs.clear();
    }

    class WrappedInternalNpc {
        private final BqInternalNpcFactory factory;
        private final String internalId;
        private BqInternalNpc npc;

        public WrappedInternalNpc(BqInternalNpcFactory factory, BqInternalNpc npc) {
            this.factory = factory;
            this.npc = npc;
            this.internalId = npc.getInternalId();
        }

        @NotNull
        public String getId() {
            return BqNpcManagerImplementation.this.getNpcId(this.factory, this.internalId);
        }

        @NotNull
        public BqInternalNpc getNpc() {
            return this.npc;
        }
    }
}

