/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.npcs.dialogs;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.npcs.dialogs.Message;
import fr.skytasul.quests.api.npcs.dialogs.MessageSender;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class ActionBarMessageSender
implements MessageSender {
    private final Map<Player, BukkitTask> players = new HashMap<Player, BukkitTask>();

    @Override
    public void displayMessage(final @NotNull Player player, @NotNull DialogRunner dialog, final @NotNull Message message) {
        if (this.players.containsKey(player)) {
            this.players.remove(player).cancel();
        }
        String sent = message.formatMessage(player, dialog.getNpc(), dialog.getDialog().getNPCName(dialog.getNpc()), dialog.getDialog().getMessages().indexOf(message), dialog.getDialog().getMessages().size());
        final BaseComponent[] components = TextComponent.fromLegacyText((String)sent.replace("{nl}", " "));
        if (message.getWaitTime() > 60) {
            this.players.put(player, new BukkitRunnable(){
                int time = 0;

                public void run() {
                    if (!player.isOnline() || this.time >= message.getWaitTime()) {
                        this.cancel();
                        ActionBarMessageSender.this.players.remove(player);
                        return;
                    }
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, components);
                    this.time += 40;
                }
            }.runTaskTimerAsynchronously((Plugin)QuestsPlugin.getPlugin(), 0L, 40L));
        }
    }

    @Override
    public void stopDisplayingMessages(@NotNull Player player, @NotNull DialogRunner dialog) {
        BukkitTask task = this.players.remove(player);
        if (task != null) {
            task.cancel();
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent());
        }
    }
}

