/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import java.util.OptionalInt;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionCustomOrder
extends QuestOption<OptionalInt> {
    public OptionCustomOrder() {
        super(new Class[0]);
    }

    @Override
    @Nullable
    public Integer save() {
        return ((OptionalInt)this.getValue()).isEmpty() ? null : Integer.valueOf(((OptionalInt)this.getValue()).getAsInt());
    }

    @Override
    public void load(@NotNull ConfigurationSection config, @NotNull String key) {
        if (config.contains(key)) {
            this.setValue(OptionalInt.of(config.getInt(key)));
        }
    }

    @Override
    @Nullable
    public OptionalInt cloneValue(@Nullable OptionalInt value) {
        return value;
    }

    private String[] getLore() {
        return new String[]{QuestOption.formatDescription(Lang.optionCustomOrderLore.toString()), "", QuestOption.formatNullableValue((Object)(((OptionalInt)this.getValue()).isEmpty() ? null : Integer.valueOf(((OptionalInt)this.getValue()).getAsInt())), !this.hasCustomValue())};
    }

    @Override
    @NotNull
    public ItemStack getItemStack(@NotNull OptionSet options) {
        return ItemUtils.item(XMaterial.REDSTONE, Lang.optionCustomOrder.toString(), this.getLore());
    }

    @Override
    public void click(@NotNull QuestCreationGuiClickEvent event) {
        Lang.QUEST_CUSTOM_ORDER.send((CommandSender)event.getPlayer());
        new TextEditor<Integer>(event.getPlayer(), event::reopen, newValue -> {
            if (newValue == null) {
                this.resetValue();
            } else {
                this.setValue(OptionalInt.of(newValue));
            }
            ItemUtils.lore(event.getClicked(), this.getLore());
            event.reopen();
        }, NumberParser.INTEGER_PARSER).passNullIntoEndConsumer().start();
    }
}

