/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOptionString;
import fr.skytasul.quests.api.options.description.QuestDescriptionContext;
import fr.skytasul.quests.api.options.description.QuestDescriptionProvider;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OptionDescription
extends QuestOptionString
implements QuestDescriptionProvider {
    private Cache<QuestDescriptionContext, List<String>> cachedDescription = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();

    public OptionDescription() {
        super(new Class[0]);
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        if (this.cachedDescription != null) {
            this.cachedDescription.invalidateAll();
        }
    }

    @Override
    public void sendIndication(Player p) {
        Lang.QUEST_DESCRIPTION.send((CommandSender)p);
    }

    @Override
    public XMaterial getItemMaterial() {
        return XMaterial.OAK_SIGN;
    }

    @Override
    public String getItemName() {
        return Lang.customDescription.toString();
    }

    @Override
    public String getItemDescription() {
        return Lang.customDescriptionLore.toString();
    }

    @Override
    public boolean isMultiline() {
        return true;
    }

    @Override
    public List<String> provideDescription(QuestDescriptionContext context) {
        List<String> description = (List<String>)this.cachedDescription.getIfPresent((Object)context);
        if (description == null) {
            description = Arrays.asList("\u00a77" + MessageUtils.finalFormat((String)this.getValue(), null, PlaceholdersContext.of(context.getQuester(), true, null)));
            this.cachedDescription.put((Object)context, description);
        }
        return description;
    }

    @Override
    public String getDescriptionId() {
        return "description";
    }

    @Override
    public double getDescriptionPriority() {
        return 0.0;
    }
}

