/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class OptionFirework
extends QuestOption<FireworkMeta> {
    public OptionFirework() {
        super(new Class[0]);
    }

    @Override
    public Object save() {
        return this.getValue();
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue((FireworkMeta)config.getSerializable(key, FireworkMeta.class));
    }

    @Override
    public FireworkMeta cloneValue(FireworkMeta value) {
        return value.clone();
    }

    private List<String> getLore() {
        ArrayList<String> lore = new ArrayList<String>(9);
        lore.add(QuestOption.formatDescription(Lang.optionFireworkLore.toString()));
        lore.add("");
        if (this.getValue() == null) {
            lore.add(Lang.NotSet.toString());
        } else {
            lore.add("\u00a78> \u00a77\u00a7l" + ((FireworkMeta)this.getValue()).getEffectsSize() + " \u00a78effect(s)");
            lore.add("\u00a78> Power: \u00a77\u00a7l" + ((FireworkMeta)this.getValue()).getPower());
        }
        if (!this.hasCustomValue()) {
            lore.add("");
            lore.add(Lang.defaultValue.toString());
        }
        lore.add("");
        lore.add("\u00a78" + Lang.ClickRight.toString() + " > \u00a7c" + Lang.Remove.toString());
        if (this.hasCustomValue()) {
            lore.add("\u00a78" + Lang.ClickShiftRight.toString() + " > \u00a7d" + Lang.Reset.toString());
        }
        lore.add("\u00a77\u00a7l" + Lang.optionFireworkDrop.toString());
        return lore;
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item(XMaterial.FIREWORK_ROCKET, Lang.optionFirework.toString(), this.getLore());
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        if (event.hasCursor()) {
            ItemMeta cursorMeta = event.getCursor().getItemMeta();
            if (cursorMeta instanceof FireworkMeta) {
                this.setValue((FireworkMeta)cursorMeta);
                ItemUtils.lore(event.getClicked(), this.getLore());
                QuestUtils.runSync(() -> event.getPlayer().setItemOnCursor(null));
                Lang.FIREWORK_EDITED.send((CommandSender)event.getPlayer());
            } else {
                Lang.FIREWORK_INVALID.send((CommandSender)event.getPlayer());
            }
        } else if (event.getClick() == ClickType.SHIFT_RIGHT) {
            this.resetValue();
            ItemUtils.lore(event.getClicked(), this.getLore());
        } else if (event.getClick() == ClickType.RIGHT) {
            this.setValue(null);
            Lang.FIREWORK_REMOVED.send((CommandSender)event.getPlayer());
            ItemUtils.lore(event.getClicked(), this.getLore());
        }
    }

    @Override
    public boolean shouldDisplay(OptionSet options) {
        return QuestsConfiguration.getConfig().getQuestsConfig().fireworks();
    }
}

