/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.utils.QuestUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class OptionQuestItem
extends QuestOption<ItemStack> {
    public OptionQuestItem() {
        super(new Class[0]);
    }

    @Override
    public void setValue(ItemStack value) {
        value = value == null || value.getType() == Material.AIR ? XMaterial.BOOK.parseItem() : ItemUtils.clearVisibleAttributes(value.clone());
        super.setValue(value);
    }

    @Override
    public Object save() {
        return this.getValue();
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(config.isItemStack(key) ? config.getItemStack(key) : XMaterial.valueOf((String)config.getString(key)).parseItem());
    }

    @Override
    public ItemStack cloneValue(ItemStack value) {
        return value.clone();
    }

    private String[] getLore() {
        String description = OptionQuestItem.formatDescription(Lang.customMaterialLore.toString());
        if (!this.hasCustomValue()) {
            return new String[]{description, "", Lang.defaultValue.toString()};
        }
        return new String[]{description};
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.nameAndLore(((ItemStack)this.getValue()).clone(), Lang.customMaterial.toString(), this.getLore());
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        if (event.hasCursor()) {
            ItemStack item = event.getCursor();
            QuestUtils.runSync(() -> {
                this.setValue(item);
                event.getPlayer().setItemOnCursor(null);
            });
        } else {
            Lang.QUEST_MATERIAL.send((CommandSender)event.getPlayer());
            new TextEditor<XMaterial>(event.getPlayer(), event::reopen, obj -> {
                if (obj == null) {
                    this.resetValue();
                } else {
                    this.setValue(obj.parseItem());
                }
                ItemStack setItem = event.getGui().getInventory().getItem(event.getSlot());
                if (setItem == null || setItem.getType() == Material.AIR) {
                    this.resetValue();
                    Lang.INVALID_ITEM_TYPE.send((CommandSender)event.getPlayer());
                }
                event.reopen();
            }, QuestsPlugin.getPlugin().getEditorManager().getFactory().getMaterialParser(true, true)).passNullIntoEndConsumer().start();
        }
    }
}

