/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.OpenCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.pools.QuestPool;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class OptionQuestPool
extends QuestOption<QuestPool> {
    public OptionQuestPool() {
        super(new Class[0]);
    }

    @Override
    public void attach(Quest quest) {
        super.attach(quest);
        if (this.getValue() != null) {
            ((QuestPool)this.getValue()).addQuest(quest);
        }
    }

    @Override
    public void detach() {
        if (this.getValue() != null) {
            ((QuestPool)this.getValue()).removeQuest(this.getAttachedQuest());
        }
        super.detach();
    }

    @Override
    public Object save() {
        return ((QuestPool)this.getValue()).getId();
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(BeautyQuests.getInstance().getPoolsManager().getPool(config.getInt(key)));
    }

    @Override
    public QuestPool cloneValue(QuestPool value) {
        return value;
    }

    private List<String> getLore() {
        ArrayList<String> lore = new ArrayList<String>(5);
        lore.add(OptionQuestPool.formatDescription(Lang.questPoolLore.toString()));
        lore.add("");
        lore.add(this.formatValue(this.getValue() == null ? null : "#" + ((QuestPool)this.getValue()).getId()));
        if (this.hasCustomValue()) {
            lore.add("");
            lore.add("\u00a78" + Lang.ClickShiftRight.toString() + " > \u00a7d" + Lang.Reset.toString());
        }
        return lore;
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item(XMaterial.CHEST, Lang.questPool.toString(), this.getLore());
    }

    @Override
    public void click(final QuestCreationGuiClickEvent event) {
        if (event.getClick() == ClickType.SHIFT_RIGHT) {
            this.setValue(null);
            ItemUtils.lore(event.getClicked(), this.getLore());
        } else {
            new PagedGUI<QuestPool>(Lang.INVENTORY_POOLS_LIST.toString(), DyeColor.CYAN, BeautyQuests.getInstance().getPoolsManager().getPools(), list -> event.reopen(), null){

                @Override
                public ItemStack getItemStack(QuestPool object) {
                    return object.getItemStack(Lang.poolChoose.toString());
                }

                @Override
                public void click(QuestPool existing, ItemStack poolItem, ClickType click) {
                    OptionQuestPool.this.setValue(existing);
                    ItemUtils.lore(event.getClicked(), OptionQuestPool.this.getLore());
                    event.reopen();
                }

                @Override
                public CloseBehavior onClose(Player p) {
                    return new OpenCloseBehavior(event.getGui());
                }
            }.open(event.getPlayer());
        }
    }
}

