/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.description.QuestDescriptionContext;
import fr.skytasul.quests.api.options.description.QuestDescriptionProvider;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategy;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategyCreator;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionQuesterStrategy
extends QuestOption<QuestQuesterStrategy>
implements QuestDescriptionProvider {
    public OptionQuesterStrategy() {
        super(new Class[0]);
    }

    @Override
    @Nullable
    public Object save() {
        MemoryConfiguration section = new MemoryConfiguration();
        ((QuestQuesterStrategy)this.getValue()).serialize((ConfigurationSection)section);
        return section.getValues(false);
    }

    @Override
    public void load(@NotNull ConfigurationSection config, @NotNull String key) {
        this.setValue(QuestQuesterStrategy.deserialize(config.getConfigurationSection(key), QuestsAPI.getAPI().getQuestQuesterStrategyRegistry()));
    }

    @Override
    @Nullable
    public QuestQuesterStrategy cloneValue(@Nullable QuestQuesterStrategy value) {
        return (QuestQuesterStrategy)value.clone();
    }

    @Override
    @NotNull
    public ItemStack getItemStack(@NotNull OptionSet options) {
        QuestQuesterStrategyCreator strategyCreator = (QuestQuesterStrategyCreator)((QuestQuesterStrategy)this.getValue()).getCreator();
        boolean isEditable = this.getValue() instanceof QuestQuesterStrategy.EditableStrategy;
        return ItemUtils.item(XMaterial.PLAYER_HEAD, "\u00a7b" + String.valueOf(Lang.optionQuesterStrategy), "", QuestOption.formatNullableValue((Object)strategyCreator.getName(), !this.hasCustomValue()), "", QuestOption.formatDescription(strategyCreator.getDescription()), "", "\u00a78" + String.valueOf(Lang.ClickLeft) + " > \u00a77" + String.valueOf(Lang.pickAnother), isEditable ? "\u00a78" + String.valueOf(Lang.ClickRight) + " > \u00a77" + String.valueOf(Lang.edit) : null);
    }

    @Override
    public boolean shouldDisplay(@NotNull OptionSet options) {
        return QuestsAPI.getAPI().getQuestQuesterStrategyRegistry().getCreators().size() > 1;
    }

    @Override
    public void click(final @NotNull QuestCreationGuiClickEvent event) {
        Object t;
        if (event.getClick() == ClickType.LEFT) {
            new PagedGUI<QuestQuesterStrategyCreator>("Choose a strategy", DyeColor.MAGENTA, QuestsAPI.getAPI().getQuestQuesterStrategyRegistry().getCreators()){

                @Override
                @NotNull
                public ItemStack getItemStack(@NotNull QuestQuesterStrategyCreator object) {
                    return ItemUtils.item(XMaterial.PLAYER_HEAD, object.getName(), QuestOption.formatDescription(object.getDescription()));
                }

                @Override
                public void click(@NotNull QuestQuesterStrategyCreator existing, @NotNull ItemStack item, @NotNull ClickType clickType) {
                    OptionQuesterStrategy.this.setValue((QuestQuesterStrategy)existing.newObject());
                    event.getGui().updateOptionItem(OptionQuesterStrategy.this);
                    event.reopen();
                }
            }.open(event.getPlayer());
        } else if (event.getClick() == ClickType.RIGHT && (t = this.getValue()) instanceof QuestQuesterStrategy.EditableStrategy) {
            QuestQuesterStrategy.EditableStrategy strategy = (QuestQuesterStrategy.EditableStrategy)t;
            strategy.click(event);
        }
    }

    @Override
    @Nullable
    public @Nullable List<@Nullable String> provideDescription(@NotNull QuestDescriptionContext context) {
        String description = ((QuestQuesterStrategy)this.getValue()).getTooltip(context);
        if (description == null) {
            return null;
        }
        return List.of(description);
    }

    @Override
    @NotNull
    public String getDescriptionId() {
        return "quester_strategy";
    }

    @Override
    public double getDescriptionPriority() {
        return 30.0;
    }
}

