/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.DialogEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.npcs.dialogs.Dialog;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.stages.types.Dialogable;
import fr.skytasul.quests.options.OptionStarterNPC;
import fr.skytasul.quests.utils.types.DialogRunnerImplementation;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class OptionStartDialog
extends QuestOption<Dialog>
implements Dialogable {
    private DialogRunnerImplementation runner;

    public OptionStartDialog() {
        super(OptionStarterNPC.class);
    }

    @Override
    public Object save() {
        MemoryConfiguration section = new MemoryConfiguration();
        ((Dialog)this.getValue()).serialize((ConfigurationSection)section);
        return section;
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(Dialog.deserialize(config.getConfigurationSection(key)));
    }

    @Override
    public Dialog cloneValue(Dialog value) {
        return value.clone();
    }

    @Override
    public boolean shouldDisplay(OptionSet options) {
        return options.getOption(OptionStarterNPC.class).getValue() != null;
    }

    private String[] getLore() {
        return new String[]{OptionStartDialog.formatDescription(Lang.startDialogLore.toString()), "", this.getValue() == null ? Lang.NotSet.toString() : "\u00a77" + Lang.AmountDialogLines.quickFormat("lines_amount", ((Dialog)this.getValue()).getMessages().size())};
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item(XMaterial.WRITABLE_BOOK, Lang.startDialog.toString(), this.getLore());
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        Lang.NPC_TEXT.send((CommandSender)event.getPlayer());
        if (this.getValue() == null) {
            this.setValue(new Dialog());
        }
        new DialogEditor(event.getPlayer(), () -> {
            ItemUtils.lore(event.getClicked(), this.getLore());
            event.reopen();
        }, (Dialog)this.getValue()).start();
    }

    @Override
    public Dialog getDialog() {
        return (Dialog)this.getValue();
    }

    @Override
    public BqNpc getNPC() {
        return (BqNpc)this.getAttachedQuest().getOptionValueOrDef(OptionStarterNPC.class);
    }

    @Override
    public void detach() {
        super.detach();
        if (this.runner != null) {
            this.runner.unload();
            this.runner = null;
        }
    }

    @Override
    public DialogRunner getDialogRunner() {
        if (this.runner == null) {
            this.runner = new DialogRunnerImplementation((Dialog)this.getValue(), this.getNPC());
            this.runner.addEndAction(p -> this.getAttachedQuest().attemptStart((Player)p));
        }
        return this.runner;
    }
}

