/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.options.OptionQuestPool;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class OptionStarterNPC
extends QuestOption<BqNpc> {
    public OptionStarterNPC() {
        super(OptionQuestPool.class);
    }

    @Override
    public Object save() {
        return ((BqNpc)this.getValue()).getId();
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(QuestsPlugin.getPlugin().getNpcManager().getById(config.getString(key)));
    }

    @Override
    public BqNpc cloneValue(BqNpc value) {
        return value;
    }

    private List<String> getLore(OptionSet options) {
        ArrayList<String> lore = new ArrayList<String>(4);
        lore.add(OptionStarterNPC.formatDescription(Lang.questStarterSelectLore.toString()));
        lore.add(null);
        if (options != null && options.hasOption(OptionQuestPool.class) && options.getOption(OptionQuestPool.class).hasCustomValue()) {
            lore.add(Lang.questStarterSelectPool.toString());
        }
        lore.add((String)(this.getValue() == null ? Lang.NotSet.toString() : "\u00a77" + ((BqNpc)this.getValue()).getNpc().getName() + " \u00a78(" + ((BqNpc)this.getValue()).getId() + ")"));
        return lore;
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item(XMaterial.VILLAGER_SPAWN_EGG, Lang.questStarterSelect.toString(), this.getLore(options));
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        QuestsPlugin.getPlugin().getGuiManager().getFactory().createNpcSelection(event::reopen, npc -> {
            this.setValue(npc);
            ItemUtils.lore(event.getClicked(), this.getLore(event.getGui().getOptionSet()));
            event.reopen();
        }, true).open(event.getPlayer());
    }
}

