/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.DurationParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.options.OptionRepeatable;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class OptionTimer
extends QuestOption<Integer> {
    public OptionTimer() {
        super(OptionRepeatable.class);
    }

    @Override
    public Object save() {
        return this.getValue();
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(config.getInt(key));
    }

    @Override
    public Integer cloneValue(Integer value) {
        return value;
    }

    @Override
    public boolean shouldDisplay(OptionSet options) {
        return (Boolean)options.getOption(OptionRepeatable.class).getValue();
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item(XMaterial.CLOCK, Lang.timer.toString(), this.getLore());
    }

    private String[] getLore() {
        return new String[]{OptionTimer.formatDescription(Lang.timerLore.toString()), "", this.formatValue(Utils.millisToHumanString((long)((Integer)this.getValue()).intValue() * 60L * 1000L))};
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        Lang.TIMER.send((CommandSender)event.getPlayer());
        new TextEditor<Long>(event.getPlayer(), event::reopen, obj -> {
            if (obj == null) {
                this.resetValue();
            } else {
                this.setValue(obj.intValue());
            }
            ItemUtils.lore(event.getClicked(), this.getLore());
            event.reopen();
        }, DurationParser.MinecraftTimeUnit.MINUTE.getParser()).passNullIntoEndConsumer().start();
    }
}

