/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.options;

import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.base.XBase;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.utils.QuestVisibilityLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OptionVisibility
extends QuestOption<List<QuestVisibilityLocation>> {
    public OptionVisibility() {
        super(new Class[0]);
    }

    @Override
    public Object save() {
        return ((List)this.getValue()).stream().map(Enum::name).collect(Collectors.toList());
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        if (config.isBoolean(key)) {
            this.setValue(Collections.emptyList());
        } else {
            this.setValue(config.getStringList(key).stream().map(QuestVisibilityLocation::valueOf).collect(Collectors.toList()));
        }
    }

    @Override
    public List<QuestVisibilityLocation> cloneValue(List<QuestVisibilityLocation> value) {
        return new ArrayList<QuestVisibilityLocation>(value);
    }

    private String[] getLore() {
        return new String[]{OptionVisibility.formatDescription(Lang.optionVisibilityLore.toString()), "", this.formatValue(((List)this.getValue()).stream().map(QuestVisibilityLocation::getName).collect(Collectors.joining(", ")))};
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item((XMaterial)XMaterial.SPYGLASS.or((XBase)XMaterial.BOOKSHELF), Lang.optionVisibility.toString(), this.getLore());
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        new VisibilityGUI(() -> {
            ItemUtils.lore(event.getClicked(), this.getLore());
            event.reopen();
        }).open(event.getPlayer());
    }

    class VisibilityGUI
    extends AbstractGui {
        private EnumMap<QuestVisibilityLocation, Boolean> locations = new EnumMap(QuestVisibilityLocation.class);
        private Runnable reopen;

        public VisibilityGUI(Runnable reopen) {
            this.reopen = reopen;
        }

        @Override
        protected Inventory instanciate(@NotNull Player player) {
            return Bukkit.createInventory(null, (InventoryType)InventoryType.HOPPER, (String)Lang.INVENTORY_VISIBILITY.toString());
        }

        @Override
        protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
            for (int i = 0; i < 4; ++i) {
                QuestVisibilityLocation loc = QuestVisibilityLocation.values()[i];
                boolean visible = ((List)OptionVisibility.this.getValue()).contains((Object)loc);
                this.locations.put(loc, visible);
                inventory.setItem(i, ItemUtils.itemSwitch(loc.getName(), visible, new String[0]));
            }
            inventory.setItem(4, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone());
        }

        @Override
        public void onClick(GuiClickEvent event) {
            if (event.getSlot() >= 0 && event.getSlot() < 4) {
                this.locations.put(QuestVisibilityLocation.values()[event.getSlot()], ItemUtils.toggleSwitch(event.getClicked()));
            } else if (event.getSlot() == 4) {
                OptionVisibility.this.setValue(this.locations.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList()));
                this.reopen.run();
            }
        }

        @Override
        public CloseBehavior onClose(Player p) {
            return new DelayCloseBehavior(this.reopen);
        }
    }
}

