/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.players;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.utils.ParticleEffect;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminMode {
    private static final Set<CommandSender> senders = new HashSet<CommandSender>();
    private static final ParticleEffect enterParticle = new ParticleEffect(Particle.FLAME, null, null);
    private static final ParticleEffect leaveParticle = new ParticleEffect(Utils.valueOfEnum(Particle.class, "SMOKE_NORMAL", "SMOKE"), null, null);

    public static void toggle(CommandSender sender) {
        if (senders.add(sender)) {
            Lang.ADMIN_MODE_ENTERED.send(sender);
            if (sender instanceof Player) {
                Player player = (Player)sender;
                enterParticle.sendParticle(player.getEyeLocation(), AdminMode.getAdminPlayers(), 1.0, 1.0, 1.0, 15);
            }
        } else {
            senders.remove(sender);
            Lang.ADMIN_MODE_LEFT.send(sender);
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (senders.stream().anyMatch(Player.class::isInstance)) {
                    leaveParticle.sendParticle(player.getEyeLocation(), AdminMode.getAdminPlayers(), 1.0, 1.0, 1.0, 15);
                }
            }
        }
    }

    public static void broadcast(String message) {
        BeautyQuests.getInstance().getLoggerExpanded().debug("[ADMIN]: " + message);
        for (CommandSender p : senders) {
            p.sendMessage("\u00a7e" + message);
        }
    }

    public static Set<CommandSender> getAdminSenders() {
        return senders;
    }

    public static List<Player> getAdminPlayers() {
        return senders.stream().filter(Player.class::isInstance).map(Player.class::cast).collect(Collectors.toList());
    }
}

