/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.players;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.api.questers.data.QuesterDataManager;
import fr.skytasul.quests.api.questers.events.QuesterJoinEvent;
import fr.skytasul.quests.api.questers.events.QuesterLeaveEvent;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import fr.skytasul.quests.players.AbstractPlayerQuesterImplementation;
import fr.skytasul.quests.players.PlayerQuesterImplementation;
import fr.skytasul.quests.utils.DebugUtils;
import fr.skytasul.quests.utils.QuestUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.UnmodifiableView;

public class PlayerManagerImplementation
implements PlayerManager,
Listener {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.PlayerManager");
    @NotNull
    public static final Key KEY = Key.key((String)"beautyquests", (String)"players");
    @NotNull
    private final @NotNull Map<@NotNull Player, @NotNull AbstractPlayerQuesterImplementation> cachedQuesters = new HashMap<Player, AbstractPlayerQuesterImplementation>();
    private final QuestsPlugin plugin;
    private QuesterManager questerManager;
    private boolean playersLoaded = false;

    public PlayerManagerImplementation(@NotNull QuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public Key key() {
        return KEY;
    }

    @Override
    @NotNull
    public @UnmodifiableView Collection<? extends PlayerQuester> getLoadedQuesters() {
        return this.cachedQuesters.values();
    }

    @Override
    @NotNull
    public Optional<String> getQuesterName(@NotNull String identifier) {
        UUID uuid = UUID.fromString(identifier);
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        return Optional.ofNullable(player.getName());
    }

    @NotNull
    public Optional<Quester> getQuester(@NotNull String identifier) {
        UUID uuid = UUID.fromString(identifier);
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        if (player.isOnline()) {
            return Optional.ofNullable((Quester)this.cachedQuesters.get(player.getPlayer()));
        }
        return Optional.empty();
    }

    @Override
    public @UnknownNullability PlayerQuester getQuester(@NotNull Player p) {
        if (this.plugin.getNpcManager().isNPC((Entity)p)) {
            return null;
        }
        if (!p.isOnline()) {
            LOGGER.severe("Trying to fetch the account of an offline player (" + p.getName() + ")");
            LOGGER.debug("(via " + DebugUtils.stackTraces(2, 5) + ")");
        }
        return this.cachedQuesters.get(p);
    }

    @Override
    public void load(@NotNull QuesterManager questerManager) {
        this.questerManager = questerManager;
    }

    @NotNull
    protected Optional<String> getIdentifier(@NotNull OfflinePlayer p) {
        return Optional.of(p.getUniqueId().toString());
    }

    protected AbstractPlayerQuesterImplementation createQuester(@NotNull String identifier, @NotNull QuesterData dataHandler) {
        return new PlayerQuesterImplementation(this, dataHandler, UUID.fromString(identifier));
    }

    protected void load(@NotNull Player player) {
        String identifier = this.getIdentifier((OfflinePlayer)player).orElseThrow();
        LOGGER.debug("Loading quester for {} (identifier: {})", player.getName(), identifier);
        this.questerManager.getDataManager().fetchQuester(new QuesterDataManager.QuesterFetchRequest(KEY, identifier, true, true)).whenComplete((BiConsumer)LOGGER.logError(result -> {
            boolean isCreation;
            if (!result.type().isSuccess()) {
                LOGGER.severe("Failed to load {}'s quester instance", player.getName());
                return;
            }
            boolean bl = isCreation = result.type() == QuesterDataManager.QuesterFetchResult.Type.SUCCESS_CREATED;
            if (isCreation) {
                LOGGER.debug("Created data for quester {0}", identifier);
            }
            AbstractPlayerQuesterImplementation quester = this.createQuester(identifier, result.dataHandler());
            this.cachedQuesters.put(player, quester);
            QuestUtils.runOrSync(() -> {
                if (player.isOnline()) {
                    Bukkit.getPluginManager().callEvent((Event)new QuesterJoinEvent(quester, player, isCreation));
                } else {
                    LOGGER.warning("{} has left the server while loading its data.", player.getName());
                    if (isCreation) {
                        result.dataHandler().delete().whenComplete(LOGGER.logError("Failed to delete the quester for {}", player.getName()));
                    }
                }
            });
        }, "Failed to load quester data", this.plugin.getAudiences().player(player), new Object[0]));
    }

    protected void unload(@NotNull Player player) {
        LOGGER.debug("Unloading quester for {}", player.getName());
        AbstractPlayerQuesterImplementation quester = this.cachedQuesters.get(player);
        if (quester == null) {
            throw new IllegalArgumentException("Player does not have quester loaded");
        }
        Bukkit.getPluginManager().callEvent((Event)new QuesterLeaveEvent(quester, player));
        try {
            quester.save();
        }
        catch (DataSavingException ex) {
            LOGGER.severe("Failed to save {}'s data", ex, quester.getDetailedName());
        }
        quester.unload();
        this.cachedQuesters.remove(player);
    }

    public void loadOnlinePlayers() {
        if (this.playersLoaded) {
            throw new IllegalStateException("Online players have already been loaded");
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.load(player);
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.playersLoaded = true;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(PlayerJoinEvent e) {
        this.load(e.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.unload(e.getPlayer());
    }
}

