/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.players;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.players.AbstractPlayerQuesterImplementation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.pointer.Pointers;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerQuesterImplementation
extends AbstractPlayerQuesterImplementation
implements ForwardingAudience {
    @NotNull
    private final UUID uuid;
    private OfflinePlayer offPlayer;
    private Player player;

    protected PlayerQuesterImplementation(@NotNull PlayerManager playersManager, @NotNull QuesterData dataHandler, @NotNull UUID uuid) {
        super(playersManager, dataHandler);
        this.uuid = uuid;
    }

    @Override
    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        if (this.offPlayer == null) {
            this.offPlayer = Bukkit.getOfflinePlayer((UUID)this.uuid);
        }
        return this.offPlayer;
    }

    @Override
    @NotNull
    public Optional<Player> getPlayer() {
        if (this.player == null) {
            this.player = Bukkit.getPlayer((UUID)this.uuid);
            if (this.player != null) {
                this.offPlayer = this.player;
            }
        } else if (!this.player.isOnline()) {
            this.player = null;
        }
        return Optional.ofNullable(this.player);
    }

    @Override
    public boolean isActive() {
        return this.getOfflinePlayer().isOnline();
    }

    @Override
    @NotNull
    public Collection<Player> getOnlinePlayers() {
        return this.getPlayer().filter(OfflinePlayer::isOnline).map(List::of).orElse(List.of());
    }

    @Override
    @NotNull
    public Collection<OfflinePlayer> getOfflinePlayers() {
        return List.of(this.getOfflinePlayer());
    }

    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.getPlayer().map(arg_0 -> ((BukkitAudiences)QuestsPlugin.getPlugin().getAudiences()).player(arg_0)).map(List::of).orElse(List.of());
    }

    @Override
    protected void createdPointers(@NotNull Pointers.Builder builder) {
        super.createdPointers(builder);
        builder.withStatic(Identity.UUID, (Object)this.uuid);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PlayerQuesterImplementation)) {
            return false;
        }
        PlayerQuesterImplementation quester = (PlayerQuesterImplementation)object;
        return this.uuid.equals(quester.uuid);
    }

    public int hashCode() {
        return 7 * this.uuid.hashCode();
    }

    @Override
    @NotNull
    public String getFriendlyName() {
        String name = this.getOfflinePlayer().getName();
        if (name == null) {
            name = this.uuid.toString();
        }
        return name;
    }

    @Override
    @NotNull
    public String getDetailedName() {
        return "player " + this.getFriendlyName();
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.uuid.toString();
    }
}

