/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.players.accounts;

import fr.skytasul.accounts.Account;
import fr.skytasul.accounts.AccountsProvider;
import fr.skytasul.accounts.events.AccountJoinEvent;
import fr.skytasul.accounts.events.AccountLeaveEvent;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.players.AbstractPlayerQuesterImplementation;
import fr.skytasul.quests.players.PlayerManagerImplementation;
import fr.skytasul.quests.players.accounts.PlayerQuesterAccountsHookImplementation;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerManagerAccountsHookImplementation
extends PlayerManagerImplementation {
    @NotNull
    private static final Key KEY = Key.key((String)"BeautyQuests", (String)"players-accounts-hook");

    public PlayerManagerAccountsHookImplementation(@NotNull QuestsPlugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public Key key() {
        return KEY;
    }

    @Override
    @NotNull
    public Optional<String> getQuesterName(@NotNull String identifier) {
        return this.getAccountsProvider().getFromIdentifier(NamespacedKey.fromString((String)identifier)).map(acc -> acc.getOfflinePlayer().getName());
    }

    @Override
    @NotNull
    protected Optional<String> getIdentifier(@NotNull OfflinePlayer p) {
        if (!p.isOnline()) {
            QuestsPlugin.getPlugin().getLogger().warning("Cannot fetch player identifier of an offline player with AccountsHook");
            return Optional.empty();
        }
        return Optional.of(this.getAccountsProvider().getCurrentAccount(p.getPlayer()).getIdentifier().toString());
    }

    @Override
    protected AbstractPlayerQuesterImplementation createQuester(@NotNull String identifier, @NotNull QuesterData dataHandler) {
        return new PlayerQuesterAccountsHookImplementation(this, dataHandler, (Account)this.getAccountsProvider().getFromIdentifier(NamespacedKey.fromString((String)identifier)).orElseThrow());
    }

    @NotNull
    private AccountsProvider getAccountsProvider() {
        return Objects.requireNonNull((AccountsProvider)Bukkit.getServicesManager().load(AccountsProvider.class));
    }

    @Override
    public void onJoin(PlayerJoinEvent e) {
    }

    @Override
    public void onQuit(PlayerQuitEvent e) {
    }

    @EventHandler
    public void onAccountUse(AccountJoinEvent e) {
        if (!e.isFromDefaultProvider()) {
            return;
        }
        super.load(e.getPlayer());
    }

    @EventHandler
    public void onAccountLeave(AccountLeaveEvent e) {
        if (!e.isFromDefaultProvider()) {
            return;
        }
        super.unload(e.getPlayer());
    }
}

