/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.players.accounts;

import fr.skytasul.accounts.Account;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.data.QuesterData;
import fr.skytasul.quests.players.AbstractPlayerQuesterImplementation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.pointer.Pointers;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerQuesterAccountsHookImplementation
extends AbstractPlayerQuesterImplementation
implements ForwardingAudience {
    @NotNull
    public final Account acc;

    protected PlayerQuesterAccountsHookImplementation(@NotNull PlayerManager playersManager, @NotNull QuesterData dataHandler, @NotNull Account account) {
        super(playersManager, dataHandler);
        this.acc = account;
    }

    @Override
    @NotNull
    public OfflinePlayer getOfflinePlayer() {
        return this.acc.getOfflinePlayer();
    }

    @Override
    @NotNull
    public Optional<Player> getPlayer() {
        return this.acc.getPlayer();
    }

    @Override
    public boolean isActive() {
        return this.acc.isCurrent();
    }

    @Override
    @NotNull
    public Collection<Player> getOnlinePlayers() {
        return this.acc.getPlayer().map(List::of).orElse(List.of());
    }

    @Override
    @NotNull
    public Collection<OfflinePlayer> getOfflinePlayers() {
        return List.of(this.acc.getOfflinePlayer());
    }

    @NotNull
    public Iterable<? extends Audience> audiences() {
        return this.acc.getPlayer().map(arg_0 -> ((BukkitAudiences)QuestsPlugin.getPlugin().getAudiences()).player(arg_0)).map(List::of).orElse(List.of());
    }

    @Override
    protected void createdPointers(@NotNull Pointers.Builder builder) {
        super.createdPointers(builder);
        builder.withStatic(Identity.UUID, (Object)this.acc.getOfflinePlayer().getUniqueId());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.acc.equals((Object)((PlayerQuesterAccountsHookImplementation)object).acc);
    }

    public int hashCode() {
        return 11 * this.acc.hashCode();
    }

    @Override
    @NotNull
    public String getFriendlyName() {
        return this.acc.getOfflinePlayer().getName();
    }

    @Override
    @NotNull
    public String getDetailedName() {
        return "player account " + (this.acc.isCurrent() ? ((Player)this.acc.getPlayer().get()).getName() : this.acc.getIdentifier().toString());
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return this.acc.getIdentifier().toString();
    }
}

